/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import net.soulwolf.widget.speedyselector.GradientDrawableWrapper;
import net.soulwolf.widget.speedyselector.R;
import net.soulwolf.widget.speedyselector.SpeedyStateListDrawable;
import net.soulwolf.widget.speedyselector.StateType;

class BackgroundDelegate<BACKGROUND extends View> {
    BACKGROUND mBackgroundSelector;
    SpeedyStateListDrawable mSpeedyStateListDrawable;
    private float mRadius;
    private float mBorderWidth = 3.0f;
    private boolean justBorder;

    BackgroundDelegate(BACKGROUND selector, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (selector == null) {
            throw new NullPointerException("selector == null");
        }
        this.mBackgroundSelector = selector;
        this.applyBackgroundAttributeSet(attrs, defStyleAttr, defStyleRes);
    }

    void applyBackgroundAttributeSet(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Drawable background;
        TypedArray a;
        this.mSpeedyStateListDrawable = new SpeedyStateListDrawable();
        if (attrs != null && (a = this.mBackgroundSelector.getContext().obtainStyledAttributes(attrs, R.styleable.SpeedySelectorBackground, defStyleAttr, defStyleRes)) != null) {
            this.mRadius = a.getDimension(R.styleable.SpeedySelectorBackground_spRadius, this.mRadius);
            this.justBorder = a.getBoolean(R.styleable.SpeedySelectorBackground_spJustBorder, this.justBorder);
            this.mBorderWidth = a.getDimension(R.styleable.SpeedySelectorBackground_spBorderWidth, this.mBorderWidth);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateDefaultBackground, StateType.STATE_DEFAULT);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateFocusedBackground, StateType.STATE_FOCUSED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateWindowFocusedBackground, StateType.STATE_WINDOW_FOCUSED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateEnabledBackground, StateType.STATE_ENABLED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateCheckedBackground, StateType.STATE_CHECKED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateSelectedBackground, StateType.STATE_SELECTED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateActivatedBackground, StateType.STATE_ACTIVATED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStatePressedBackground, StateType.STATE_PRESSED);
            this.parserBackgroundAttribute(a, R.styleable.SpeedySelectorBackground_spStateActiveBackground, StateType.STATE_ACTIVE);
            a.recycle();
        }
        if ((background = this.mBackgroundSelector.getBackground()) instanceof ColorDrawable) {
            this.addStateBackground(StateType.STATE_DEFAULT, this.mRadius, this.justBorder, this.mBorderWidth, ((ColorDrawable)background).getColor());
        } else {
            this.mSpeedyStateListDrawable.addStateDrawable(background);
        }
        this.requestSelector();
    }

    void parserBackgroundAttribute(TypedArray a, int index, StateType state) {
        if (a.hasValue(index)) {
            int color = a.getColor(index, -1);
            if (color != -1) {
                this.addStateBackground(state, this.mRadius, this.justBorder, this.mBorderWidth, color);
            } else {
                int resourceId = a.getResourceId(index, -1);
                if (resourceId != -1) {
                    this.addStateBackground(state, this.getResources().getDrawable(resourceId));
                }
            }
        }
    }

    public void addStateBackground(StateType state, Drawable drawable) {
        this.mSpeedyStateListDrawable.addStateDrawable(state, drawable);
    }

    public void addStateBackgroundResource(StateType state, @DrawableRes int draRes) {
        this.addStateBackground(state, this.getResources().getDrawable(draRes));
    }

    public void addStateBackground(StateType state, float radius, @ColorInt int color) {
        this.addStateBackground(state, radius, this.justBorder, color);
    }

    public void addStateBackground(StateType state, float radius, boolean justBorder, @ColorInt int colors) {
        this.addStateBackground(state, radius, justBorder, this.mBorderWidth, colors);
    }

    public void addStateBackground(StateType state, float radius, boolean justBorder, float borderWidth, @ColorInt int colors) {
        this.addStateBackground(state, (Drawable)new GradientDrawableWrapper(radius, justBorder, borderWidth, colors));
    }

    public void addStateBackgroundResource(StateType state, float radius, @ColorRes int colorRes) {
        this.addStateBackground(state, radius, this.getColor(colorRes));
    }

    public void addStateBackgroundResource(StateType state, float radius, boolean justBorder, @ColorRes int colorRes) {
        this.addStateBackground(state, radius, justBorder, this.getColor(colorRes));
    }

    public void addStateBackgroundResource(StateType state, float radius, boolean justBorder, float borderWidth, @ColorRes int colorRes) {
        this.addStateBackground(state, radius, justBorder, borderWidth, this.getColor(colorRes));
    }

    public void requestSelector() {
        if (this.mSpeedyStateListDrawable != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mBackgroundSelector.setBackground((Drawable)this.mSpeedyStateListDrawable.build());
            } else {
                this.mBackgroundSelector.setBackgroundDrawable((Drawable)this.mSpeedyStateListDrawable.build());
            }
        }
    }

    protected Resources getResources() {
        return this.mBackgroundSelector.getResources();
    }

    protected int getColor(@ColorRes int res) {
        return this.getResources().getColor(res);
    }
}

