/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.materialradio.widget;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.ImageView;
import net.soulwolf.widget.materialradio.listener.OnStateButtonCheckedListener;

public class MaterialStateButton
extends ImageView
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "MaterialStateButton:";
    private boolean mChecked;
    private OnStateButtonCheckedListener mOnStateButtonCheckedListener;

    public MaterialStateButton(Context context) {
        super(context);
    }

    public MaterialStateButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MaterialStateButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            if (this.mOnStateButtonCheckedListener != null) {
                this.mOnStateButtonCheckedListener.onCheckedChanged(this.mChecked);
            }
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
        if (this.mOnStateButtonCheckedListener != null) {
            this.mOnStateButtonCheckedListener.onCheckedToggle();
        }
    }

    public boolean performClick() {
        if (!this.isChecked()) {
            this.toggle();
        }
        return super.performClick();
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            MaterialStateButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setOnStateButtonCheckedListener(OnStateButtonCheckedListener listener) {
        this.mOnStateButtonCheckedListener = listener;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ownState = (SavedState)state;
        super.onRestoreInstanceState(ownState.getSuperState());
        this.setChecked(ownState.checked);
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ownState = new SavedState(superState);
        ownState.checked = this.mChecked;
        return ownState;
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean checked;

        private SavedState(Parcel source) {
            super(source);
            this.checked = source.readInt() == 1;
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.checked ? 1 : 0);
        }
    }
}

