/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.materialradio;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.Checkable;
import android.widget.FrameLayout;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import net.soulwolf.widget.materialradio.R;
import net.soulwolf.widget.materialradio.listener.OnButtonCheckedChangeListener;
import net.soulwolf.widget.materialradio.listener.OnStateButtonCheckedListener;
import net.soulwolf.widget.materialradio.widget.MaterialStateButton;
import net.soulwolf.widget.materialradio.widget.MaterialStateText;

public class MaterialCompoundButton
extends FrameLayout
implements Checkable,
OnStateButtonCheckedListener {
    private boolean mBroadcasting;
    protected int mPadding;
    protected int mButtonRes;
    protected Drawable mButtonDrawable;
    protected CharSequence mText;
    protected float mTextSize;
    protected ColorStateList mColorColorStateList;
    protected MaterialStateButton mButtonView;
    protected MaterialStateText mButtonText;
    protected View mSpaceView;
    protected boolean mAnimator;
    protected long mDuration = 300L;
    protected boolean mChecked;
    private OnButtonCheckedChangeListener mOnButtonCheckedChangeListener;
    private OnButtonCheckedChangeListener mOnCheckedChangeWidgetListener;

    public MaterialCompoundButton(Context context) {
        this(context, null);
    }

    public MaterialCompoundButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialCompoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.mcl_compound_button, (ViewGroup)this, true);
        this.mButtonView = (MaterialStateButton)this.findViewById(R.id.mci_compound_button_image);
        this.mSpaceView = this.findViewById(R.id.mci_compound_button_padding);
        this.mButtonText = (MaterialStateText)this.findViewById(R.id.mci_compound_button_text);
        this.mButtonView.setOnStateButtonCheckedListener(this);
        this.applyAttributeSet(context, attrs);
        if (this.isAnimator()) {
            ViewHelper.setScaleX((View)this, (float)0.85f);
            ViewHelper.setScaleY((View)this, (float)0.85f);
        }
    }

    private void applyAttributeSet(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialCompoundButton);
        this.mChecked = typedArray.getBoolean(R.styleable.MaterialCompoundButton_mcChecked, this.mChecked);
        this.setAnimator(typedArray.getBoolean(R.styleable.MaterialCompoundButton_mcAnimator, this.isAnimator()));
        this.mButtonRes = typedArray.getResourceId(R.styleable.MaterialCompoundButton_mcButton, 0);
        if (this.mButtonRes != 0) {
            this.setButtonRes(this.mButtonRes);
        }
        this.setButtonPadding(typedArray.getDimensionPixelOffset(R.styleable.MaterialCompoundButton_mcPadding, 0));
        this.setText(typedArray.getText(R.styleable.MaterialCompoundButton_mcText));
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.MaterialCompoundButton_mcTextSize, 15));
        this.setTextColor(typedArray.getColorStateList(R.styleable.MaterialCompoundButton_mcTextColor));
        typedArray.recycle();
    }

    public void setAnimator(boolean isAnim) {
        this.mAnimator = isAnim;
    }

    public boolean isAnimator() {
        return this.mAnimator;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setChecked(boolean checked) {
        this.mButtonView.setChecked(checked);
        this.mButtonText.setChecked(checked);
    }

    @Override
    public void onCheckedChanged(boolean isChecked) {
        this.mButtonText.setChecked(isChecked);
        if (this.mBroadcasting) {
            return;
        }
        this.mBroadcasting = true;
        if (this.mOnButtonCheckedChangeListener != null) {
            this.mOnButtonCheckedChangeListener.onCheckedChanged(this, isChecked);
        }
        if (this.mOnCheckedChangeWidgetListener != null) {
            this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, isChecked);
        }
        this.mBroadcasting = false;
        if (this.isAnimator()) {
            if (this.isChecked()) {
                this.start();
            } else {
                this.end();
            }
        }
    }

    private void start() {
        if (this.canAnimate()) {
            this.clearAnimation();
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])new float[]{1.0f}));
        animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])new float[]{1.0f}));
        animatorSet.setInterpolator((Interpolator)new OvershootInterpolator());
        animatorSet.setDuration(this.getDuration());
        animatorSet.start();
    }

    private void end() {
        if (this.canAnimate()) {
            this.clearAnimation();
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])new float[]{0.85f}));
        animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])new float[]{0.85f}));
        animatorSet.setInterpolator((Interpolator)new OvershootInterpolator());
        animatorSet.setDuration(this.getDuration());
        animatorSet.start();
    }

    @Override
    public void onCheckedToggle() {
        this.mButtonText.toggle();
    }

    public boolean isChecked() {
        return this.mButtonView.isChecked();
    }

    public void toggle() {
        this.mButtonView.toggle();
        this.mButtonText.toggle();
    }

    public void setButtonPadding(int padding) {
        this.mSpaceView.getLayoutParams().height = this.mPadding = padding;
        this.mSpaceView.requestLayout();
    }

    public void setButtonRes(int mButtonRes) {
        this.mButtonRes = mButtonRes;
        this.setButtonDrawable(this.getResources().getDrawable(mButtonRes));
    }

    public void setButtonDrawable(Drawable drawable) {
        this.mButtonDrawable = drawable;
        this.mButtonView.setImageDrawable(this.mButtonDrawable);
    }

    public void setText(@StringRes int resId) {
        this.setText(this.getResources().getString(resId));
    }

    public void setText(CharSequence text) {
        this.mText = text;
        this.mButtonText.setText(this.mText);
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mButtonText.setTextSize(this.mTextSize);
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.mColorColorStateList = colorStateList;
        this.mButtonText.setTextColor(this.mColorColorStateList);
    }

    public void setTextColor(@ColorInt int color) {
        this.setTextColor(ColorStateList.valueOf((int)color));
    }

    public void setOnCheckedChangeListener(OnButtonCheckedChangeListener mOnButtonCheckedChangeListener) {
        this.mOnButtonCheckedChangeListener = mOnButtonCheckedChangeListener;
    }

    public void setOnCheckedChangeWidgetListener(OnButtonCheckedChangeListener mOnCheckedChangeWidgetListener) {
        this.mOnCheckedChangeWidgetListener = mOnCheckedChangeWidgetListener;
        this.setChecked(this.mChecked);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)MaterialCompoundButton.class.getName());
        event.setChecked(this.mButtonView.isChecked());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)MaterialCompoundButton.class.getName());
        info.setCheckable(true);
        info.setChecked(this.mButtonView.isChecked());
    }
}

