/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.materialradio.utils;

import android.os.Build;
import android.view.View;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;

public class Utils {
    private static final String LOG_TAG = "Utils:";
    private static final boolean DEBUG = false;
    private static Class R_attr = null;
    private static Class R_styleable = null;
    private static final AtomicInteger sNextGeneratedId;

    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }

    public static int attr(String field) {
        if (R_attr == null) {
            return 0;
        }
        try {
            Field idField = R_attr.getField(field);
            return idField.getInt(field);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int[] styleables(String field) {
        try {
            if (R_styleable != null && R_styleable.getDeclaredField(field).get(R_styleable) != null && R_styleable.getDeclaredField(field).get(R_styleable).getClass().isArray()) {
                return (int[])R_styleable.getDeclaredField(field).get(R_styleable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new int[0];
    }

    static {
        try {
            R_styleable = Class.forName("com.android.internal.R$styleable");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            R_attr = Class.forName("com.android.internal.R$attr");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        sNextGeneratedId = new AtomicInteger(1);
    }
}

