/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.materialradio;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.FrameLayout;
import net.soulwolf.widget.materialradio.R;
import net.soulwolf.widget.materialradio.listener.OnCheckedChangeListener;
import net.soulwolf.widget.materialradio.widget.MaterialStateButton;
import net.soulwolf.widget.materialradio.widget.MaterialStateText;

public class MaterialCompoundButton
extends FrameLayout
implements Checkable,
OnCheckedChangeListener {
    private boolean mBroadcasting;
    protected int mPadding;
    protected int mButtonRes;
    protected Drawable mButtonDrawable;
    protected CharSequence mText;
    protected float mTextSize;
    protected ColorStateList mColorColorStateList;
    protected MaterialStateButton mButtonView;
    protected MaterialStateText mButtonText;
    protected View mSpaceView;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;

    public MaterialCompoundButton(Context context) {
        this(context, null);
    }

    public MaterialCompoundButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialCompoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.mcl_compound_button, (ViewGroup)this, true);
        this.mButtonView = (MaterialStateButton)this.findViewById(R.id.mci_compound_button_image);
        this.mSpaceView = this.findViewById(R.id.mci_compound_button_padding);
        this.mButtonText = (MaterialStateText)this.findViewById(R.id.mci_compound_button_text);
        this.mButtonView.setOnCheckedChangeListener(this);
        this.applyAttributeSet(context, attrs);
    }

    private void applyAttributeSet(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialCompoundButton);
        this.setChecked(typedArray.getBoolean(R.styleable.MaterialCompoundButton_mcChecked, this.isChecked()));
        this.mButtonRes = typedArray.getResourceId(R.styleable.MaterialCompoundButton_mcButton, 0);
        if (this.mButtonRes != 0) {
            this.setButtonRes(this.mButtonRes);
        }
        this.setButtonPadding(typedArray.getDimensionPixelOffset(R.styleable.MaterialCompoundButton_mcPadding, 0));
        this.setText(typedArray.getText(R.styleable.MaterialCompoundButton_mcText));
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.MaterialCompoundButton_mcTextSize, 15));
        this.setTextColor(typedArray.getColorStateList(R.styleable.MaterialCompoundButton_mcTextColor));
        typedArray.recycle();
    }

    public void setChecked(boolean checked) {
        this.mButtonView.setChecked(checked);
        this.mButtonText.setChecked(checked);
    }

    @Override
    public void onCheckedChanged(MaterialCompoundButton compoundView, boolean isChecked) {
        this.mButtonText.setChecked(isChecked);
        if (this.mBroadcasting) {
            return;
        }
        this.mBroadcasting = true;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, isChecked);
        }
        if (this.mOnCheckedChangeWidgetListener != null) {
            this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, isChecked);
        }
        this.mBroadcasting = false;
    }

    public boolean isChecked() {
        return this.mButtonView.isChecked();
    }

    public void toggle() {
        this.mButtonView.toggle();
        this.mButtonText.toggle();
    }

    public void setButtonPadding(int padding) {
        this.mSpaceView.getLayoutParams().height = this.mPadding = padding;
        this.mSpaceView.requestLayout();
    }

    public void setButtonRes(int mButtonRes) {
        this.mButtonRes = mButtonRes;
        this.setButtonDrawable(this.getResources().getDrawable(mButtonRes));
    }

    public void setButtonDrawable(Drawable drawable) {
        this.mButtonDrawable = drawable;
        this.mButtonView.setImageDrawable(this.mButtonDrawable);
    }

    public void setText(@StringRes int resId) {
        this.setText(this.getResources().getString(resId));
    }

    public void setText(CharSequence text) {
        this.mText = text;
        this.mButtonText.setText(this.mText);
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mButtonText.setTextSize(this.mTextSize);
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.mColorColorStateList = colorStateList;
        this.mButtonText.setTextColor(this.mColorColorStateList);
    }

    public void setTextColor(@ColorInt int color) {
        this.setTextColor(ColorStateList.valueOf((int)color));
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener mOnCheckedChangeListener) {
        this.mOnCheckedChangeListener = mOnCheckedChangeListener;
    }

    public void setOnCheckedChangeWidgetListener(OnCheckedChangeListener mOnCheckedChangeWidgetListener) {
        this.mOnCheckedChangeWidgetListener = mOnCheckedChangeWidgetListener;
    }
}

