/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import net.snowflake.client.jdbc.internal.apache.commons.codec.binary.Base64;
import net.snowflake.spark.snowflake.Conversions$;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!\u0002\u0006\f\u0001-\u0011\u0002\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\t\u000b}\u0001A\u0011\u0001\u0011\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000b}\u0003A\u0011\u00011\t\u000b=\u0004A\u0011\u00019\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0005=\u0019fn\\<gY\u0006\\Wm\u0016:ji\u0016\u0014(B\u0001\u0007\u000e\u0003%\u0019hn\\<gY\u0006\\WM\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011A\u0002\u0005\u0006\u0002#\u0005\u0019a.\u001a;\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\u0006kI\n\u001cwK]1qa\u0016\u00148\u0001\u0001\t\u00039ui\u0011aC\u0005\u0003=-\u00111B\u0013#C\u0007^\u0013\u0018\r\u001d9fe\u00061A(\u001b8jiz\"\"!\t\u0012\u0011\u0005q\u0001\u0001\"B\r\u0003\u0001\u0004Y\u0012\u0001B:bm\u0016$R!\n\u00156\u0013:\u0003\"\u0001\u0006\u0014\n\u0005\u001d*\"\u0001B+oSRDQ!K\u0002A\u0002)\n!b]9m\u0007>tG/\u001a=u!\tY3'D\u0001-\u0015\tic&A\u0002tc2T!AD\u0018\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0005\u0003i1\u0012!bU)M\u0007>tG/\u001a=u\u0011\u001514\u00011\u00018\u0003\u0011!\u0017\r^1\u0011\u0005a2eBA\u001dE\u001d\tQ4I\u0004\u0002<\u0005:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fi\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0005A\n\u0014B\u0001\b0\u0013\tic&\u0003\u0002FY\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002FY!)!j\u0001a\u0001\u0017\u0006A1/\u0019<f\u001b>$W\r\u0005\u0002,\u0019&\u0011Q\n\f\u0002\t'\u00064X-T8eK\")qj\u0001a\u0001!\u00061\u0001/\u0019:b[N\u0004\"!\u0015/\u000f\u0005ISfBA*Z\u001d\t!\u0006L\u0004\u0002V/:\u0011QHV\u0005\u0002#%\u0011A\u0002E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005m[\u0011A\u0003)be\u0006lW\r^3sg&\u0011QL\u0018\u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT!aW\u0006\u0002\u00135\f\u0007oQ8mk6tG\u0003B1hS*\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0017\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'AC*ueV\u001cG\u000fV=qK\")\u0001\u000e\u0002a\u0001C\u000611o\u00195f[\u0006DQa\u0014\u0003A\u0002ACQa\u001b\u0003A\u00021\fab\u001d8po\u001ad\u0017m[3TifdW\r\u0005\u0002\u0015[&\u0011a.\u0006\u0002\b\u0005>|G.Z1o\u00039!\u0017\r^1Ge\u0006lW\rV8S\t\u0012#b!]?\u007f\u007f\u0006\u0005\u0001\u0003\u0002\u000bsi\u0006L!a]\u000b\u0003\rQ+\b\u000f\\33!\r)\bP_\u0007\u0002m*\u0011qOL\u0001\u0004e\u0012$\u0017BA=w\u0005\r\u0011F\t\u0012\t\u0003)mL!\u0001`\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003*\u000b\u0001\u0007!\u0006C\u00037\u000b\u0001\u0007q\u0007C\u0003P\u000b\u0001\u0007\u0001\u000bC\u0004\u0002\u0004\u0015\u0001\r!!\u0002\u0002\r\u0019|'/\\1u!\u0011\t9!!\u0006\u000f\t\u0005%\u0011q\u0002\b\u0004%\u0006-\u0011bAA\u0007\u0017\u0005\u0011\u0011n\\\u0005\u0005\u0003#\t\u0019\"A\bTkB\u0004xN\u001d;fI\u001a{'/\\1u\u0015\r\tiaC\u0005\u0005\u0003/\tIBA\bTkB\u0004xN\u001d;fI\u001a{'/\\1u\u0015\u0011\t\t\"a\u0005\u0002)A\u0014X\r]1sKN\u001b\u0007.Z7b\r>\u0014(j]8o)\r\t\u0017q\u0004\u0005\u0006Q\u001a\u0001\r!Y\u0001\u001eO\u0016t7i\u001c8wKJ\u001c\u0018n\u001c8Gk:\u001cG/[8og\u001a{'OS:p]R1\u0011QEA\u0019\u0003g\u0001R\u0001FA\u0014\u0003WI1!!\u000b\u0016\u0005\u0015\t%O]1z!\u0015!\u0012Q\u0006>{\u0013\r\ty#\u0006\u0002\n\rVt7\r^5p]FBQ\u0001[\u0004A\u0002\u0005DQaT\u0004A\u0002A\u000bAC]3n_Z,Wk]3mKN\u001c8i\u001c7v[:\u001cH#B\u001c\u0002:\u0005u\u0002BBA\u001e\u0011\u0001\u0007q'A\u0005eCR\fgI]1nK\")q\n\u0003a\u0001!\u00061r-\u001a8D_:4XM]:j_:4UO\\2uS>t7\u000f\u0006\u0004\u0002&\u0005\r\u0013Q\t\u0005\u0006Q&\u0001\r!\u0019\u0005\u0006\u001f&\u0001\r\u0001\u0015")
public class SnowflakeWriter {
    private final JDBCWrapper jdbcWrapper;

    public void save(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        Dataset<Row> output;
        Tuple2<RDD<Object>, StructType> tuple2;
        Enumeration.Value format;
        block17: {
            Enumeration.Value value2 = params.useParquetInWrite() ? SupportedFormat$.MODULE$.PARQUET() : (Utils$.MODULE$.containVariant(data.schema()) ? (params.useJsonInWrite() ? SupportedFormat$.MODULE$.JSON() : SupportedFormat$.MODULE$.PARQUET()) : (format = SupportedFormat$.MODULE$.CSV()));
            if (params.columnMap().isEmpty()) {
                String string = params.columnMapping();
                String string2 = "name";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    try (ServerConnection conn = this.jdbcWrapper.getConnector(params);){
                        Some toSchema = new Some((Object)Utils$.MODULE$.removeQuote(this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params)));
                        params.setColumnMap((Option<StructType>)Option$.MODULE$.apply((Object)data.schema()), (Option<StructType>)toSchema);
                    }
                }
            }
            if (params.columnMap().isDefined()) {
                Enumeration.Value value3 = format;
                Enumeration.Value value4 = SupportedFormat$.MODULE$.PARQUET();
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    try (ServerConnection conn = this.jdbcWrapper.getConnector(params);){
                        StructType toSchema = Utils$.MODULE$.removeQuote(this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params));
                        Option<Map<String, String>> option = params.columnMap();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Map map = (Map)some.value();
                            map.values().foreach((Function1 & Serializable & scala.Serializable)value -> {
                                SnowflakeWriter.$anonfun$save$1(toSchema, value);
                                return BoxedUnit.UNIT;
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block17;
                        }
                        throw new MatchError(option);
                    }
                }
            }
        }
        Enumeration.Value value5 = format;
        Enumeration.Value value6 = SupportedFormat$.MODULE$.PARQUET();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            try (ServerConnection conn = this.jdbcWrapper.getConnector(params);){
                if (this.jdbcWrapper.tableExists(params, ((TableName)params.table().get()).name())) {
                    StructType toSchema = this.jdbcWrapper.resolveTable(conn, ((TableName)params.table().get()).name(), params);
                    params.setSnowflakeTableSchema(DefaultJDBCWrapper$.MODULE$.snowflakeStyleSchema(toSchema, params));
                }
            }
        }
        if ((tuple2 = this.dataFrameToRDD(sqlContext, output = this.removeUselessColumns(data, params), params, format)) == null) {
            throw new MatchError(tuple2);
        }
        RDD strRDD = (RDD)tuple2._1();
        StructType schema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)strRDD, (Object)schema);
        Tuple2 tuple23 = tuple22;
        RDD strRDD2 = (RDD)tuple23._1();
        StructType schema2 = (StructType)tuple23._2();
        package$.MODULE$.writeRDD(sqlContext, params, (RDD<Object>)strRDD2, schema2, saveMode, format);
    }

    public StructType mapColumn(StructType schema, Parameters.MergedParameters params, boolean snowflakeStyle) {
        StructType structType;
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            structType = StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dataType;
                String string;
                Metadata metadata;
                boolean nullable;
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType2 = structField.dataType();
                    nullable = structField.nullable();
                    metadata = structField.metadata();
                    string = params.replaceSpecialCharacter(snowflakeStyle ? DefaultJDBCWrapper$.MODULE$.snowflakeStyleString((String)map.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> name), params) : (String)map.getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> name), snowflakeStyle);
                    DataType dataType3 = dataType2;
                    if (dataType3 instanceof StructType) {
                        StructType structType = (StructType)dataType3;
                        dataType = this.mapColumn(structType, params, false);
                    } else {
                        dataType = dataType2;
                    }
                } else {
                    throw new MatchError((Object)structField);
                }
                StructField structField2 = new StructField(string, dataType, nullable, metadata);
                return structField2;
            }, Seq$.MODULE$.canBuildFrom()));
        } else {
            StructType newSchema = params.snowflakeTableSchema() == null ? (snowflakeStyle ? DefaultJDBCWrapper$.MODULE$.snowflakeStyleSchema(schema, params) : schema) : StructType$.MODULE$.apply((Seq)((TraversableLike)schema.zip((GenIterable)params.snowflakeTableSchema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField field1 = (StructField)tuple2._1();
                StructField field2 = (StructField)tuple2._2();
                StructField structField = new StructField(field2.name(), field1.dataType(), field1.nullable(), field1.metadata());
                return structField;
            }, Seq$.MODULE$.canBuildFrom()));
            structType = StructType$.MODULE$.apply((Seq)newSchema.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DataType dataType;
                String string;
                Metadata metadata;
                boolean nullable;
                StructField structField = x0$3;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType2 = structField.dataType();
                    nullable = structField.nullable();
                    metadata = structField.metadata();
                    string = params.replaceSpecialCharacter(name, snowflakeStyle);
                    DataType dataType3 = dataType2;
                    if (dataType3 instanceof StructType) {
                        StructType structType = (StructType)dataType3;
                        dataType = this.mapColumn(structType, params, false);
                    } else {
                        dataType = dataType2;
                    }
                } else {
                    throw new MatchError((Object)structField);
                }
                StructField structField2 = new StructField(string, dataType, nullable, metadata);
                return structField2;
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return structType;
    }

    public Tuple2<RDD<Object>, StructType> dataFrameToRDD(SQLContext sqlContext, Dataset<Row> data, Parameters.MergedParameters params, Enumeration.Value format) {
        Tuple2 tuple2;
        SparkSession spark = sqlContext.sparkSession();
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.PARQUET();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType snowflakeStyleSchema = this.mapColumn(data.schema(), params, true);
            tuple2 = new Tuple2((Object)data.rdd(), (Object)snowflakeStyleSchema);
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Function1<Object, Object>[] conversionFunction = this.genConversionFunctions(data.schema(), params);
                tuple2 = new Tuple2((Object)data.rdd().map((Function1 & Serializable & scala.Serializable)row -> ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])conversionFunction), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object element = tuple2._1();
                    Function1 func = (Function1)tuple2._2();
                    Object object = func.apply(element);
                    return object;
                }, Seq$.MODULE$.canBuildFrom())).mkString("|"), ClassTag$.MODULE$.Any()), (Object)data.schema());
            } else {
                Enumeration.Value value6 = SupportedFormat$.MODULE$.JSON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    StructType newSchema = this.prepareSchemaForJson(data.schema());
                    Function1<Object, Object>[] conversionsFunction = this.genConversionFunctionsForJson(data.schema(), params);
                    RDD newData = data.rdd().map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.fromSeq((Seq)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])conversionsFunction), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object element = tuple2._1();
                        Function1 func = (Function1)tuple2._2();
                        Object object = func.apply(element);
                        return object;
                    }, Seq$.MODULE$.canBuildFrom())), ClassTag$.MODULE$.apply(Row.class));
                    tuple2 = new Tuple2((Object)spark.createDataFrame(newData, newSchema).toJSON().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), spark.implicits().newStringEncoder()).rdd(), (Object)data.schema());
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return tuple2;
    }

    private StructType prepareSchemaForJson(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField == null) return structField;
            StructField structField2 = structField;
            DataType dataType = structField2.dataType();
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            if (dataType != null) {
                if (!dataType.equals(binaryType$)) return structField;
                return new StructField(structField2.name(), (DataType)StringType$.MODULE$, structField2.nullable(), structField2.metadata());
            }
            if (binaryType$ == null) return new StructField(structField2.name(), (DataType)StringType$.MODULE$, structField2.nullable(), structField2.metadata());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private Function1<Object, Object>[] genConversionFunctionsForJson(StructType schema, Parameters.MergedParameters params) {
        return (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            Function1 & Serializable & scala.Serializable intersect = StringType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> params.trimSpace() ? v.toString().trim() : v : (BinaryType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    string = Base64.encodeBase64String((byte[])byArray);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (Function1 & Serializable & scala.Serializable)input -> input);
            return intersect;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    private Dataset<Row> removeUselessColumns(Dataset<Row> dataFrame, Parameters.MergedParameters params) {
        Dataset dataset;
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Dataset dataset2;
            Some some = (Some)option;
            Map map = (Map)some.value();
            Seq names = (Seq)map.keys().toSeq().map((Function1 & Serializable & scala.Serializable)name -> name.contains(".") ? new StringBuilder(2).append("`").append((String)name).append("`").toString() : name, Seq$.MODULE$.canBuildFrom());
            try {
                dataset2 = dataFrame.select((String)names.head(), (Seq)names.tail());
            }
            catch (AnalysisException e) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Incorrect column name when column mapping: ").append(e.toString()).toString());
            }
            dataset = dataset2;
        } else {
            dataset = dataFrame;
        }
        return dataset;
    }

    public Function1<Object, Object>[] genConversionFunctions(StructType schema, Parameters.MergedParameters params) {
        return (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            Function1 & Serializable & scala.Serializable intersect = DateType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    string = Conversions$.MODULE$.formatTimestamp(timestamp);
                } else if (object instanceof Date) {
                    Date date = (Date)object;
                    string = Conversions$.MODULE$.formatDate(date);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (TimestampType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> v == null ? "" : Conversions$.MODULE$.formatTimestamp((Timestamp)v) : (StringType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> {
                String string;
                if (v == null) {
                    string = "";
                } else {
                    Object trimmed = params.trimSpace() ? v.toString().trim() : v;
                    string = Conversions$.MODULE$.formatString((String)trimmed);
                }
                return string;
            } : (BinaryType$.MODULE$.equals(dataType) ? (Function1 & Serializable & scala.Serializable)v -> {
                String string;
                Object object = v;
                if (object == null) {
                    string = "";
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    string = Base64.encodeBase64String((byte[])byArray);
                } else {
                    throw new MatchError(object);
                }
                return string;
            } : (Function1 & Serializable & scala.Serializable)v -> Conversions$.MODULE$.formatAny(v))));
            return intersect;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    public static final /* synthetic */ void $anonfun$save$1(StructType toSchema$1, String value) {
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toSchema$1.fieldNames())).contains((Object)value) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toSchema$1.fieldNames())).contains((Object)value.toUpperCase())) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Column with name ").append(value).append(" does not match any column in snowflake table").toString());
        }
    }

    public SnowflakeWriter(JDBCWrapper jdbcWrapper) {
        this.jdbcWrapper = jdbcWrapper;
    }
}

