/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PBEParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PasswordConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.KDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.PBKDF1Key;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputDecryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputDecryptorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorCreationException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.ScryptParams;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.SecretKeySizeProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.jcajce.JceUtils;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean tryWrong) {
        this.wrongPKCS12Zero = tryWrong;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                block9: {
                    ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                    try {
                        if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                            PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                            this.cipher.init(2, new PKCS12KeyWithParameters(password, JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero, pbeParams.getIV(), pbeParams.getIterations().intValue()));
                            this.encryptionAlg = algorithmIdentifier;
                            break block9;
                        }
                        if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                            SecretKey key;
                            PBES2Parameters alg = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                            if (JceUtils.id_scrypt.equals(alg.getKeyDerivationFunc().getAlgorithm())) {
                                ScryptParams params = ScryptParams.getInstance(alg.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                                KDF.ScryptParameters p = KDF.SCRYPT.using(params.getSalt(), params.getCostParameter().intValue(), params.getBlockSize().intValue(), params.getParallelizationParameter().intValue(), PasswordConverter.UTF8, password);
                                byte[] keyBytes = new byte[(JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme) + 7) / 8];
                                new KDF.SCryptFactory().createKDFCalculator(p).generateBytes(keyBytes);
                                key = new SecretKeySpec(keyBytes, encScheme.getAlgorithm().getId());
                            } else {
                                SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
                                PBKDF2Params func = PBKDF2Params.getInstance(alg.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                                key = func.isDefaultPrf() ? keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme))) : keyFact.generateSecret(new PBKDF2KeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme), func.getPrf()));
                            }
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(alg.getEncryptionScheme().getAlgorithm().getId());
                            this.encryptionAlg = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
                            if (encParams instanceof ASN1OctetString) {
                                this.cipher.init(2, (Key)key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
                            } else {
                                GOST28147Parameters gParams = GOST28147Parameters.getInstance(encParams);
                                this.cipher.init(2, (Key)key, new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV()));
                            }
                            break block9;
                        }
                        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC)) {
                            PBEParameter pbeParams = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                            this.cipher.init(2, (Key)new PBKDF1Key(password, PasswordConverter.ASCII), new PBEParameterSpec(pbeParams.getSalt(), pbeParams.getIterationCount().intValue()));
                            break block9;
                        }
                        throw new OperatorCreationException("unable to create InputDecryptor: algorithm " + algorithm + " unknown.");
                    }
                    catch (Exception e) {
                        throw new OperatorCreationException("unable to create InputDecryptor: " + e.getMessage(), e);
                    }
                }
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

