/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AuthenticationParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.MACOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Blowfish;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AuthParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IvParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.Utils;

class ProvBlowfish
extends AlgorithmProvider {
    private static final String PREFIX = ProvBlowfish.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvBlowfish() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.BLOWFISH", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, Blowfish.ECBwithPKCS7, Blowfish.ECB, Blowfish.ECBwithISO10126_2, Blowfish.ECBwithISO7816_4, Blowfish.ECBwithTBC, Blowfish.ECBwithX923, Blowfish.CBC, Blowfish.CBCwithPKCS7, Blowfish.CBCwithISO10126_2, Blowfish.CBCwithISO7816_4, Blowfish.CBCwithTBC, Blowfish.CBCwithX923, Blowfish.CBCwithCS1, Blowfish.CBCwithCS2, Blowfish.CBCwithCS3, Blowfish.CFB64, Blowfish.CFB8, Blowfish.OFB, Blowfish.OpenPGPCFB, Blowfish.CTR, Blowfish.EAX).withGeneralOperators(ProvBlowfish.this.generalParametersCreatorProvider, new Blowfish.OperatorFactory(), new Blowfish.AEADOperatorFactory()).withParameters(ProvBlowfish.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, Blowfish.CBCwithPKCS7).withGeneralOperators(ProvBlowfish.this.generalParametersCreatorProvider, new Blowfish.OperatorFactory(), null).withParameters(ProvBlowfish.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.BLOWFISH", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Blowfish", 128, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Blowfish.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "BLOWFISH", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.BLOWFISHCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Blowfish.CMAC, (MACOperatorFactory)new Blowfish.MACOperatorFactory(), new AuthParametersCreator(Blowfish.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "BLOWFISHCMAC", "BLOWFISH-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.BLOWFISH", PREFIX + "$BLOWFISHKFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("Blowfish", Blowfish.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n < 32 || n > 448) {
                            throw new InvalidKeySpecException("Blowfish key must be between 32 and 448 bits inclusive");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.BLOWFISH", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("Blowfish");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "BLOWFISH", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "Blowfish", 8);
            }
        }));
    }
}

