/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidSignatureException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.UpdateOutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CryptoException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.io.Utils;

public class SignerOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private Signer sig;

    public SignerOutputStream(String string, Signer signer) {
        this.algorithmName = string;
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.sig = signer;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update((byte)n);
    }

    byte[] getSignature() throws CryptoException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.generateSignature();
    }

    boolean verify(byte[] byArray) throws InvalidSignatureException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.verifySignature(byArray);
    }
}

