/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.OperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.VariantKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.BasicKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.ConsistencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelfTestExecutor {
    SelfTestExecutor() {
    }

    static <T> T validate(Algorithm algorithm, T t, BasicKatTest<T> basicKatTest) {
        try {
            if (!basicKatTest.hasTestPassed(t)) {
                throw new OperationError("Self test failed: " + algorithm.getName());
            }
            return t;
        }
        catch (Exception exception) {
            throw new OperationError("Exception on self test: " + algorithm.getName(), exception);
        }
    }

    static <T> T validate(Algorithm algorithm, T t, ConsistencyTest<T> consistencyTest) {
        try {
            if (!consistencyTest.hasTestPassed(t)) {
                throw new OperationError("Consistency test failed: " + algorithm.getName());
            }
            return t;
        }
        catch (Exception exception) {
            throw new OperationError("Consistency test exception: " + algorithm.getName(), exception);
        }
    }

    static <T> T validate(Algorithm algorithm, T t, VariantKatTest<T> variantKatTest) {
        try {
            variantKatTest.evaluate(t);
            return t;
        }
        catch (TestFailedException testFailedException) {
            throw new OperationError(testFailedException.getMessage() + ": " + algorithm.getName());
        }
        catch (Exception exception) {
            throw new OperationError("Exception on self test: " + algorithm.getName(), exception);
        }
    }

    static class TestFailedException
    extends RuntimeException {
        public TestFailedException(String string) {
            super(string);
        }
    }
}

