/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.EcKeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECConstants;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECMultiplier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.WNafUtil;

class EcKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    EcDomainParameters params;
    SecureRandom random;

    EcKeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        EcKeyGenerationParameters ecKeyGenerationParameters = (EcKeyGenerationParameters)keyGenerationParameters;
        this.random = ecKeyGenerationParameters.getRandom();
        this.params = ecKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            throw new IllegalArgumentException("No random provided where one required.");
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new EcPublicKeyParameters(eCPoint, this.params), new EcPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

