/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsKDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class FipsAgreementParameters
extends FipsParameters {
    final FipsAlgorithm digestAlgorithm;
    final FipsKDF.PRF prfAlgorithm;
    final byte[] salt;
    final FipsKDF.AgreementKDFParametersBuilder kdfType;
    final int outputSize;

    FipsAgreementParameters(FipsAlgorithm fipsAlgorithm, FipsAlgorithm fipsAlgorithm2) {
        super(fipsAlgorithm);
        this.digestAlgorithm = fipsAlgorithm2;
        this.prfAlgorithm = null;
        this.salt = null;
        this.kdfType = null;
        this.outputSize = 0;
    }

    FipsAgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.PRF pRF, byte[] byArray) {
        super(fipsAlgorithm);
        if (pRF == null) {
            throw new NullPointerException("prfAlgorithm cannot be null");
        }
        if (byArray == null) {
            throw new NullPointerException("salt cannot be null");
        }
        this.digestAlgorithm = null;
        this.prfAlgorithm = pRF;
        this.salt = Arrays.clone(byArray);
        this.kdfType = null;
        this.outputSize = 0;
    }

    FipsAgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
        super(fipsAlgorithm);
        if (agreementKDFParametersBuilder == null) {
            throw new NullPointerException("kdfType cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("outputSize must be greater than zero");
        }
        this.digestAlgorithm = null;
        this.prfAlgorithm = null;
        this.salt = Arrays.clone(byArray);
        this.kdfType = agreementKDFParametersBuilder;
        this.outputSize = n;
    }

    public FipsAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public FipsKDF.PRF getPrfAlgorithm() {
        return this.prfAlgorithm;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }
}

