/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.BigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class NullableBigIntHolderReaderImpl
extends AbstractFieldReader {
    private NullableBigIntHolder holder;

    public NullableBigIntHolderReaderImpl(NullableBigIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.BIGINT;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(BigIntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableBigIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Long readLong() {
        if (!this.isSet()) {
            return null;
        }
        Long value = new Long(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readLong();
    }
}

