/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.core.arrow.TinyIntToFixedConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class TinyIntToScaledFixedConverter
extends TinyIntToFixedConverter {
    private String format;

    public TinyIntToScaledFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context, int sfScale) {
        super(fieldVector, columnIndex, context);
        this.logicalTypeStr = String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")});
        this.format = ArrowResultUtil.getStringFormat(sfScale);
        this.sfScale = sfScale;
    }

    @Override
    public short toShort(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        float val = this.toFloat(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", Float.valueOf(val));
    }

    @Override
    public int toInt(int index) throws SFException {
        if (this.isNull(index)) {
            return 0;
        }
        float val = this.toFloat(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Int", Float.valueOf(val));
    }

    @Override
    public float toFloat(int index) throws SFException {
        if (this.isNull(index)) {
            return 0.0f;
        }
        return (float)this.getByte(index) / (float)ArrowResultUtil.powerOfTen(this.sfScale);
    }

    @Override
    public long toLong(int index) throws SFException {
        if (this.isNull(index)) {
            return 0L;
        }
        float val = this.toFloat(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", Float.valueOf(val));
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toBigDecimal(index);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        float f = (float)this.getByte(index) / (float)ArrowResultUtil.powerOfTen(this.sfScale);
        return String.format(this.format, Float.valueOf(f));
    }
}

