/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static ThreadLocal<TelemetryService> _threadLocal = new ThreadLocal<TelemetryService>(){

        @Override
        protected TelemetryService initialValue() {
            return new TelemetryService();
        }
    };
    private static final String TELEMETRY_SERVER_URL_PATTERN = "https://(sfcdev\\.|sfctest\\.|)client-telemetry\\.snowflakecomputing\\.com/enqueue";
    private static HashSet<String> ENABLED_DEPLOYMENT = new HashSet<String>(Arrays.asList(TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.DEV), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.REG), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.QA1), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.PREPROD2), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.PROD)));
    private String connStr = "";
    private static final int DEFAULT_NUM_OF_RETRY_TO_TRIGGER_TELEMETRY = 10;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int numOfRetryToTriggerTelemetry = 10;
    private ConcurrentLinkedQueue<TelemetryEvent> queue = new ConcurrentLinkedQueue();
    private int batchSize = 100;
    private JSONObject context;
    private ExecutorService uploader = Executors.newFixedThreadPool(3);
    private TELEMETRY_SERVER_DEPLOYMENT serverDeployment;
    private boolean enabled = true;
    private boolean runFlushBeforeException = true;

    public static TelemetryService getInstance() {
        return _threadLocal.get();
    }

    private TelemetryService() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("shutdownHooks"));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new TelemetryUploader(this, this.exportQueueToString())));
        }
        catch (SecurityException e) {
            logger.debug("Failed to add shutdown hook for telemetry service");
        }
    }

    public void resetNumOfRetryToTriggerTelemetry() {
        this.numOfRetryToTriggerTelemetry = 10;
    }

    public int getNumOfRetryToTriggerTelemetry() {
        return this.numOfRetryToTriggerTelemetry;
    }

    public void setNumOfRetryToTriggerTelemetry(int num) {
        this.numOfRetryToTriggerTelemetry = num;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean runFlushBeforeException() {
        return this.runFlushBeforeException;
    }

    public void enableRunFlushBeforeException() {
        this.runFlushBeforeException = true;
    }

    public void disableRunFlushBeforeException() {
        this.runFlushBeforeException = false;
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void updateContextForIT(Map<String, String> params) {
        Properties info = new Properties();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null) continue;
            info.put(key, val);
        }
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(params.get("uri"), info);
        this.updateContext(conStr);
    }

    public void updateContext(SnowflakeConnectString conStr) {
        this.configureDeployment(conStr);
        this.context = new JSONObject();
        for (Map.Entry<String, Object> entry : conStr.getParameters().entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            if ("password".equalsIgnoreCase(k) || "privateKey".equalsIgnoreCase(k) || "passcode".equalsIgnoreCase(k)) continue;
            this.context.put(k, v);
        }
    }

    private void configureDeployment(SnowflakeConnectString conStr) {
        if (!conStr.isValid()) {
            return;
        }
        this.connStr = conStr.toString();
        String account = conStr.getAccount();
        int port = conStr.getPort();
        TELEMETRY_SERVER_DEPLOYMENT deployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
        if (conStr.getHost().contains("reg") || conStr.getHost().contains("local")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.REG;
            if (port == 8080) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.DEV;
            }
        } else if (conStr.getHost().contains("qa1") || account.contains("qa1")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
        } else if (conStr.getHost().contains("preprod2")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.PREPROD2;
        }
        this.setDeployment(deployment);
    }

    public boolean isDeploymentEnabled() {
        return ENABLED_DEPLOYMENT.contains(this.serverDeployment.name);
    }

    public TelemetryEvent peek() {
        return this.queue.peek();
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public void resetBatchSize() {
        this.batchSize = 100;
    }

    public String getDriverConnectionString() {
        return this.connStr;
    }

    public void setDeployment(TELEMETRY_SERVER_DEPLOYMENT deployment) {
        this.serverDeployment = deployment;
    }

    public String getServerDeploymentName() {
        return this.serverDeployment.name;
    }

    public void add(TelemetryEvent event) {
        if (!this.enabled) {
            return;
        }
        this.queue.offer(event);
        if (this.queue.size() >= this.batchSize || event.containsKey("Urgent") && ((Boolean)event.get("Urgent")).booleanValue()) {
            TelemetryUploader runUpload = new TelemetryUploader(this, this.exportQueueToString());
            this.uploader.execute(runUpload);
        }
    }

    public void flush() {
        if (!this.enabled) {
            return;
        }
        if (!this.queue.isEmpty()) {
            TelemetryUploader runUpload = new TelemetryUploader(this, this.exportQueueToString());
            this.uploader.execute(runUpload);
        }
    }

    public String exportQueueToString() {
        JSONArray logs = new JSONArray();
        while (!this.queue.isEmpty()) {
            logs.add(this.queue.poll());
        }
        return SecretDetector.maskSecrets(logs.toString());
    }

    public int size() {
        return this.queue.size();
    }

    public void logOCSPExceptionTelemetryEvent(String eventType, JSONObject telemetryData, CertificateException ex) {
        if (this.enabled) {
            String eventName = "OCSPException";
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            if (ex != null) {
                telemetryData.put("exceptionMessage", ex.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                telemetryData.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(telemetryData).withTag("eventType", eventType)).build();
            this.add(log);
        }
    }

    public void logHttpRequestTelemetryEvent(String eventName, HttpRequestBase request, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, CloseableHttpResponse response, Exception savedEx, String breakRetryReason, long retryTimeout, int retryCount, String sqlState, int errorCode) {
        if (this.enabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            JSONObject value = new JSONObject();
            value.put("request", request.toString());
            value.put("injectSocketTimeout", injectSocketTimeout);
            value.put("canceling", canceling == null ? "null" : Boolean.valueOf(canceling.get()));
            value.put("withoutCookies", withoutCookies);
            value.put("includeRetryParameters", includeRetryParameters);
            value.put("includeRequestGuid", includeRequestGuid);
            value.put("breakRetryReason", breakRetryReason);
            value.put("retryTimeout", retryTimeout);
            value.put("retryCount", retryCount);
            value.put("sqlState", sqlState);
            value.put("errorCode", errorCode);
            int responseStatusCode = -1;
            if (response != null) {
                value.put("response", response.toString());
                value.put("responseStatusLine", response.getStatusLine().toString());
                if (response.getStatusLine() != null) {
                    responseStatusCode = response.getStatusLine().getStatusCode();
                    value.put("responseStatusCode", responseStatusCode);
                }
            } else {
                value.put("response", null);
            }
            if (savedEx != null) {
                value.put("exceptionMessage", savedEx.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                value.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(value).withTag("sqlState", sqlState)).withTag("errorCode", errorCode)).withTag("responseStatusCode", responseStatusCode)).build();
            this.add(log);
        }
    }

    static class TelemetryUploader
    implements Runnable {
        TelemetryService instance;
        String payload;
        RequestConfig config;
        static final int TIMEOUT = 3000;

        public TelemetryUploader(TelemetryService _instance, String _payload) {
            this.instance = _instance;
            this.payload = _payload;
            this.config = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).build();
        }

        @Override
        public void run() {
            if (!this.instance.enabled) {
                return;
            }
            if (this.payload == null || this.payload.equals("[]") || this.payload.isEmpty()) {
                logger.debug("skip to run telemetry uploader for empty payload");
            } else {
                this.uploadPayload();
                logger.debug("run telemetry uploader");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadPayload() {
            boolean success;
            HttpResponse response;
            block9: {
                block8: {
                    response = null;
                    success = true;
                    if (this.instance.isDeploymentEnabled()) break block8;
                    logger.debug("skip the disabled deployment: ", this.instance.serverDeployment.name);
                    logger.debug("Telemetry request success={} and clean the current queue", success);
                    this.instance.queue.clear();
                    return;
                }
                if (this.instance.serverDeployment.url.matches(TelemetryService.TELEMETRY_SERVER_URL_PATTERN)) break block9;
                logger.debug("ignore invalid url: ", this.instance.serverDeployment.url);
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
                return;
            }
            try {
                HttpPost post = new HttpPost(this.instance.serverDeployment.url);
                post.setEntity(new StringEntity(this.payload));
                post.setHeader("Content-type", "application/json");
                post.setHeader("x-api-key", this.instance.serverDeployment.getApiKey());
                CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.config).build();
                response = httpClient.execute(post);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    logger.debug("telemetry server request success: " + response);
                } else {
                    logger.debug("telemetry server request error: " + response);
                    success = false;
                }
                logger.debug(EntityUtils.toString(response.getEntity(), "UTF-8"));
            }
            catch (Exception e) {
                try {
                    logger.debug("Telemetry request failed, Exceptionresponse: {}, exception: {}", response, e.getMessage());
                    success = false;
                }
                catch (Throwable throwable) {
                    logger.debug("Telemetry request success={} and clean the current queue", success);
                    this.instance.queue.clear();
                    throw throwable;
                }
                logger.debug("Telemetry request success={} and clean the current queue", success);
                this.instance.queue.clear();
            }
            logger.debug("Telemetry request success={} and clean the current queue", success);
            this.instance.queue.clear();
        }
    }

    public static enum TELEMETRY_SERVER_DEPLOYMENT {
        DEV("dev", TELEMETRY_API.SFCTEST),
        REG("reg", TELEMETRY_API.SFCTEST),
        QA1("qa1", TELEMETRY_API.SFCDEV),
        PREPROD2("preprod2", TELEMETRY_API.SFCDEV),
        PROD("prod", TELEMETRY_API.PROD);

        private String name;
        private String url;
        private final String apiKey;

        private TELEMETRY_SERVER_DEPLOYMENT(String name, TELEMETRY_API api) {
            this.name = name;
            this.url = api.url;
            this.apiKey = api.apiKey;
        }

        public String getURL() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setURL(String url) {
            this.url = url;
        }
    }

    private static enum TELEMETRY_API {
        SFCTEST("https://sfctest.client-telemetry.snowflakecomputing.com/enqueue", "rRNY3EPNsB4U89XYuqsZKa7TSxb9QVX93yNM4tS6"),
        SFCDEV("https://sfcdev.client-telemetry.snowflakecomputing.com/enqueue", "kyTKLWpEZSaJnrzTZ63I96QXZHKsgfqbaGmAaIWf"),
        PROD("https://client-telemetry.snowflakecomputing.com/enqueue", "wLpEKqnLOW9tGNwTjab5N611YQApOb3t9xOnE1rX");

        private final String url;
        private final String apiKey;

        private TELEMETRY_API(String host, String key) {
            this.url = host;
            this.apiKey = key;
        }
    }
}

