/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DLSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.ContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.MacData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.Pfx;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEncryptedDataGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSProcessableByteArray;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OutputEncryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.MacDataGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS12PfxPdu;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS12SafeBag;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCSIOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag data) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(data.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag data) throws IOException {
        return this.addEncryptedData(dataEncryptor, new DERSequence(data.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag[] data) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != data.length; ++i) {
            v.add(data[i].toASN1Structure());
        }
        return this.addEncryptedData(dataEncryptor, new DLSequence(v));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, ASN1Sequence data) throws IOException {
        CMSEncryptedDataGenerator envGen = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(envGen.generate(new CMSProcessableByteArray(data.getEncoded()), dataEncryptor).toASN1Structure());
        }
        catch (CMSException e) {
            throw new PKCSIOException(e.getMessage(), e.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder macCalcBuilder, char[] password) throws PKCSException {
        byte[] encAuth;
        AuthenticatedSafe auth = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            encAuth = auth.getEncoded();
        }
        catch (IOException e) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + e.getMessage(), e);
        }
        ContentInfo mainInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(encAuth));
        MacData mData = null;
        if (macCalcBuilder != null) {
            MacDataGenerator mdGen = new MacDataGenerator(macCalcBuilder);
            mData = mdGen.build(password, encAuth);
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        return new PKCS12PfxPdu(pfx);
    }
}

