/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.est;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERPrintableString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cmc.CMCException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cmc.SimplePKIResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.CACertsResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.CSRAttributesResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.CSRRequestResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.CsrAttrs;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTAuth;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTClient;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTClientProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTRequest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTRequestBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.ESTSourceConnectionListener;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.EnrollmentResponse;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.Source;
import net.snowflake.client.jdbc.internal.org.bouncycastle.est.TLSUniqueProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.ContentSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Selector;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Store;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESTService {
    protected static final String CACERTS = "/cacerts";
    protected static final String SIMPLE_ENROLL = "/simpleenroll";
    protected static final String SIMPLE_REENROLL = "/simplereenroll";
    protected static final String FULLCMC = "/fullcmc";
    protected static final String SERVERGEN = "/serverkeygen";
    protected static final String CSRATTRS = "/csrattrs";
    protected static final Set<String> illegalParts = new HashSet<String>();
    private final String server;
    private final ESTClientProvider clientProvider;
    private static final Pattern pathInvalid;

    ESTService(String serverAuthority, String label, ESTClientProvider clientProvider) {
        serverAuthority = this.verifyServer(serverAuthority);
        if (label != null) {
            label = this.verifyLabel(label);
            this.server = "https://" + serverAuthority + "/.well-known/est/" + label;
        } else {
            this.server = "https://" + serverAuthority + "/.well-known/est";
        }
        this.clientProvider = clientProvider;
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store) {
        return ESTService.storeToArray(store, null);
    }

    public static X509CertificateHolder[] storeToArray(Store<X509CertificateHolder> store, Selector<X509CertificateHolder> selector) {
        Collection<X509CertificateHolder> c = store.getMatches(selector);
        return c.toArray(new X509CertificateHolder[c.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public CACertsResponse getCACerts() throws Exception {
        resp = null;
        finalThrowable = null;
        caCertsResponse = null;
        url = null;
        failedBeforeClose = false;
        try {
            url = new URL(this.server + "/cacerts");
            client = this.clientProvider.makeClient();
            req = new ESTRequestBuilder("GET", url).withClient(client).build();
            resp = client.doRequest(req);
            caCerts = null;
            crlHolderStore = null;
            if (resp.getStatusCode() == 200) {
                if (!"application/pkcs7-mime".equals(resp.getHeaders().getFirstValue("Content-Type"))) {
                    j = resp.getHeaders().getFirstValue("Content-Type") != null ? " got " + resp.getHeaders().getFirstValue("Content-Type") : " but was not present.";
                    throw new ESTException("Response : " + url.toString() + "Expecting application/pkcs7-mime " + j, null, resp.getStatusCode(), resp.getInputStream());
                }
                try {
                    if (resp.getContentLength() == null || resp.getContentLength() <= 0L) ** GOTO lbl28
                    ain = new ASN1InputStream(resp.getInputStream());
                    spkr = new SimplePKIResponse(ContentInfo.getInstance((ASN1Sequence)ain.readObject()));
                    caCerts = spkr.getCertificates();
                    crlHolderStore = spkr.getCRLs();
                }
                catch (Throwable ex) {
                    throw new ESTException("Decoding CACerts: " + url.toString() + " " + ex.getMessage(), ex, resp.getStatusCode(), resp.getInputStream());
                }
            } else if (resp.getStatusCode() != 204) {
                throw new ESTException("Get CACerts: " + url.toString(), null, resp.getStatusCode(), resp.getInputStream());
            }
lbl28:
            // 4 sources

            caCertsResponse = new CACertsResponse(caCerts, crlHolderStore, req, resp.getSource(), this.clientProvider.isTrusted());
        }
        catch (Throwable t) {
            failedBeforeClose = true;
            if (t instanceof ESTException) {
                throw (ESTException)t;
            }
            throw new ESTException(t.getMessage(), t);
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception t) {
                    finalThrowable = t;
                }
            }
        }
        if (finalThrowable != null) {
            if (finalThrowable instanceof ESTException) {
                throw finalThrowable;
            }
            throw new ESTException("Get CACerts: " + url.toString(), (Throwable)finalThrowable, resp.getStatusCode(), null);
        }
        return caCertsResponse;
    }

    public EnrollmentResponse simpleEnroll(EnrollmentResponse priorResponse) throws Exception {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse resp = null;
        try {
            ESTClient client = this.clientProvider.makeClient();
            resp = client.doRequest(new ESTRequestBuilder(priorResponse.getRequestToRetry()).withClient(client).build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(resp);
            return enrollmentResponse;
        }
        catch (Throwable t) {
            if (t instanceof ESTException) {
                throw (ESTException)t;
            }
            throw new ESTException(t.getMessage(), t);
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    public EnrollmentResponse simpleEnroll(boolean reenroll, PKCS10CertificationRequest certificationRequest, ESTAuth auth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse resp = null;
        try {
            byte[] data = this.annotateRequest(certificationRequest.getEncoded()).getBytes();
            URL url = new URL(this.server + (reenroll ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient client = this.clientProvider.makeClient();
            ESTRequestBuilder req = new ESTRequestBuilder("POST", url).withData(data).withClient(client);
            req.addHeader("Content-Type", "application/pkcs10");
            req.addHeader("Content-Length", "" + data.length);
            req.addHeader("Content-Transfer-Encoding", "base64");
            if (auth != null) {
                auth.applyAuth(req);
            }
            resp = client.doRequest(req.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(resp);
            return enrollmentResponse;
        }
        catch (Throwable t) {
            if (t instanceof ESTException) {
                throw (ESTException)t;
            }
            throw new ESTException(t.getMessage(), t);
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    public EnrollmentResponse simpleEnrollPoP(boolean reEnroll, final PKCS10CertificationRequestBuilder builder, final ContentSigner contentSigner, ESTAuth auth) throws IOException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        ESTResponse resp = null;
        try {
            URL url = new URL(this.server + (reEnroll ? SIMPLE_REENROLL : SIMPLE_ENROLL));
            ESTClient client = this.clientProvider.makeClient();
            ESTRequestBuilder reqBldr = new ESTRequestBuilder("POST", url).withClient(client).withConnectionListener(new ESTSourceConnectionListener(){

                public ESTRequest onConnection(Source source, ESTRequest request) throws IOException {
                    if (source instanceof TLSUniqueProvider && ((TLSUniqueProvider)((Object)source)).isTLSUniqueAvailable()) {
                        PKCS10CertificationRequestBuilder localBuilder = new PKCS10CertificationRequestBuilder(builder);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        byte[] tlsUnique = ((TLSUniqueProvider)((Object)source)).getTLSUnique();
                        localBuilder.setAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, new DERPrintableString(Base64.toBase64String(tlsUnique)));
                        bos.write(ESTService.this.annotateRequest(localBuilder.build(contentSigner).getEncoded()).getBytes());
                        bos.flush();
                        ESTRequestBuilder reqBuilder = new ESTRequestBuilder(request).withData(bos.toByteArray());
                        reqBuilder.setHeader("Content-Type", "application/pkcs10");
                        reqBuilder.setHeader("Content-Transfer-Encoding", "base64");
                        reqBuilder.setHeader("Content-Length", Long.toString(bos.size()));
                        return reqBuilder.build();
                    }
                    throw new IOException("Source does not supply TLS unique.");
                }
            });
            if (auth != null) {
                auth.applyAuth(reqBldr);
            }
            resp = client.doRequest(reqBldr.build());
            EnrollmentResponse enrollmentResponse = this.handleEnrollResponse(resp);
            return enrollmentResponse;
        }
        catch (Throwable t) {
            if (t instanceof ESTException) {
                throw (ESTException)t;
            }
            throw new ESTException(t.getMessage(), t);
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    protected EnrollmentResponse handleEnrollResponse(ESTResponse resp) throws IOException {
        ESTRequest req = resp.getOriginalRequest();
        Store<X509CertificateHolder> enrolled = null;
        if (resp.getStatusCode() == 202) {
            String rt = resp.getHeader("Retry-After");
            if (rt == null) {
                throw new ESTException("Got Status 202 but not Retry-After header from: " + req.getURL().toString());
            }
            long notBefore = -1L;
            try {
                notBefore = System.currentTimeMillis() + Long.parseLong(rt) * 1000L;
            }
            catch (NumberFormatException nfe) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    notBefore = dateFormat.parse(rt).getTime();
                }
                catch (Exception ex) {
                    throw new ESTException("Unable to parse Retry-After header:" + req.getURL().toString() + " " + ex.getMessage(), null, resp.getStatusCode(), resp.getInputStream());
                }
            }
            return new EnrollmentResponse(null, notBefore, req, resp.getSource());
        }
        if (resp.getStatusCode() == 200) {
            ASN1InputStream ain = new ASN1InputStream(resp.getInputStream());
            SimplePKIResponse spkr = null;
            try {
                spkr = new SimplePKIResponse(ContentInfo.getInstance(ain.readObject()));
            }
            catch (CMCException e) {
                throw new ESTException(e.getMessage(), e.getCause());
            }
            enrolled = spkr.getCertificates();
            return new EnrollmentResponse(enrolled, -1L, null, resp.getSource());
        }
        throw new ESTException("Simple Enroll: " + req.getURL().toString(), null, resp.getStatusCode(), resp.getInputStream());
    }

    /*
     * Unable to fully structure code
     */
    public CSRRequestResponse getCSRAttributes() throws ESTException {
        if (!this.clientProvider.isTrusted()) {
            throw new IllegalStateException("No trust anchors.");
        }
        resp = null;
        response = null;
        finalThrowable = null;
        url = null;
        try {
            url = new URL(this.server + "/csrattrs");
            client = this.clientProvider.makeClient();
            req = new ESTRequestBuilder("GET", url).withClient(client).build();
            resp = client.doRequest(req);
            switch (resp.getStatusCode()) {
                case 200: {
                    try {
                        if (resp.getContentLength() != null && resp.getContentLength() > 0L) {
                            ain = new ASN1InputStream(resp.getInputStream());
                            seq = (ASN1Sequence)ain.readObject();
                            response = new CSRAttributesResponse(CsrAttrs.getInstance(seq));
                            ** break;
                        }
lbl20:
                        // 3 sources

                        break;
                    }
                    catch (Throwable ex) {
                        throw new ESTException("Decoding CACerts: " + url.toString() + " " + ex.getMessage(), ex, resp.getStatusCode(), resp.getInputStream());
                    }
                }
                case 204: {
                    response = null;
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 404: {
                    response = null;
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                default: {
                    throw new ESTException("CSR Attribute request: " + req.getURL().toString(), null, resp.getStatusCode(), resp.getInputStream());
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ESTException) {
                throw (ESTException)t;
            }
            throw new ESTException(t.getMessage(), t);
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception ex) {
                    finalThrowable = ex;
                }
            }
        }
        if (finalThrowable != null) {
            if (finalThrowable instanceof ESTException) {
                throw (ESTException)finalThrowable;
            }
            throw new ESTException(finalThrowable.getMessage(), (Throwable)finalThrowable, resp.getStatusCode(), null);
        }
        return new CSRRequestResponse(response, resp.getSource());
    }

    private String annotateRequest(byte[] data) {
        int i = 0;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        do {
            if (i + 48 < data.length) {
                pw.print(Base64.toBase64String(data, i, 48));
                i += 48;
            } else {
                pw.print(Base64.toBase64String(data, i, data.length - i));
                i = data.length;
            }
            pw.print('\n');
        } while (i < data.length);
        pw.flush();
        return sw.toString();
    }

    private String verifyLabel(String label) {
        while (label.endsWith("/") && label.length() > 0) {
            label = label.substring(0, label.length() - 1);
        }
        while (label.startsWith("/") && label.length() > 0) {
            label = label.substring(1);
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label set but after trimming '/' is not zero length string.");
        }
        if (!pathInvalid.matcher(label).matches()) {
            throw new IllegalArgumentException("Server path " + label + " contains invalid characters");
        }
        if (illegalParts.contains(label)) {
            throw new IllegalArgumentException("Label " + label + " is a reserved path segment.");
        }
        return label;
    }

    private String verifyServer(String server) {
        try {
            while (server.endsWith("/") && server.length() > 0) {
                server = server.substring(0, server.length() - 1);
            }
            if (server.contains("://")) {
                throw new IllegalArgumentException("Server contains scheme, must only be <dnsname/ipaddress>:port, https:// will be added arbitrarily.");
            }
            URL u = new URL("https://" + server);
            if (u.getPath().length() == 0 || u.getPath().equals("/")) {
                return server;
            }
            throw new IllegalArgumentException("Server contains path, must only be <dnsname/ipaddress>:port, a path of '/.well-known/est/<label>' will be added arbitrarily.");
        }
        catch (Exception ex) {
            if (ex instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)ex;
            }
            throw new IllegalArgumentException("Scheme and host is invalid: " + ex.getMessage(), ex);
        }
    }

    static {
        illegalParts.add(CACERTS.substring(1));
        illegalParts.add(SIMPLE_ENROLL.substring(1));
        illegalParts.add(SIMPLE_REENROLL.substring(1));
        illegalParts.add(FULLCMC.substring(1));
        illegalParts.add(SERVERGEN.substring(1));
        illegalParts.add(CSRATTRS.substring(1));
        pathInvalid = Pattern.compile("^[0-9a-zA-Z_\\-.~!$&'()*+,;=]+");
    }
}

