/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.EntropySource;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

class X931RNG {
    private static final long BLOCK64_RESEED_MAX = 32768L;
    private static final long BLOCK128_RESEED_MAX = 0x800000L;
    private static final int BLOCK64_MAX_BITS_REQUEST = 4096;
    private static final int BLOCK128_MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private BlockCipher engine;
    private EntropySource entropySource;
    private final byte[] DT;
    private final byte[] I;
    private final byte[] R;
    private byte[] V;
    private long reseedCounter = 1L;

    public X931RNG(BlockCipher blockCipher, byte[] byArray, EntropySource entropySource) {
        this.engine = blockCipher;
        this.entropySource = entropySource;
        this.DT = new byte[blockCipher.getBlockSize()];
        System.arraycopy(byArray, 0, this.DT, 0, this.DT.length);
        this.I = new byte[blockCipher.getBlockSize()];
        this.R = new byte[blockCipher.getBlockSize()];
    }

    public int getBlockSize() {
        return this.engine.getBlockSize() * 8;
    }

    int generate(byte[] byArray, boolean bl) {
        int n;
        if (this.R.length == 8) {
            if (this.reseedCounter > 32768L) {
                return -1;
            }
            if (X931RNG.isTooLarge(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.reseedCounter > 0x800000L) {
                return -1;
            }
            if (X931RNG.isTooLarge(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (bl || this.V == null) {
            this.V = this.getEntropy();
        }
        int n2 = byArray.length / this.R.length;
        for (n = 0; n < n2; ++n) {
            this.engine.processBlock(this.DT, 0, this.I, 0);
            this.process(this.R, this.I, this.V);
            this.process(this.V, this.R, this.I);
            System.arraycopy(this.R, 0, byArray, n * this.R.length, this.R.length);
            this.increment(this.DT);
        }
        n = byArray.length - n2 * this.R.length;
        if (n > 0) {
            this.engine.processBlock(this.DT, 0, this.I, 0);
            this.process(this.R, this.I, this.V);
            this.process(this.V, this.R, this.I);
            System.arraycopy(this.R, 0, byArray, n2 * this.R.length, n);
            this.increment(this.DT);
        }
        ++this.reseedCounter;
        return byArray.length;
    }

    void reseed() {
        this.V = this.getEntropy();
        this.reseedCounter = 1L;
    }

    private byte[] getEntropy() {
        byte[] byArray = this.entropySource.getEntropy();
        if (byArray.length != this.engine.getBlockSize()) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private void process(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)(byArray2[i] ^ byArray3[i]);
        }
        this.engine.processBlock(byArray, 0, byArray, 0);
    }

    private void increment(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] != 0) break;
        }
    }

    private static boolean isTooLarge(byte[] byArray, int n) {
        return byArray != null && byArray.length > n;
    }

    static {
        kats.put("AES", new byte[][]{Hex.decode("f7d36762b9915f1ed585eb8e91700eb2"), Hex.decode("259e67249288597a4d61e7c0e690afae"), Hex.decode("35cc0ea481fc8a4f5f05c7d4667233b2"), Hex.decode("15f013af5a8e9df9a8e37500edaeac43")});
        kats.put("DESede", new byte[][]{Hex.decode("ef16ec643e5db5892cbc6eabba310b3410e6f8759e3e382c"), Hex.decode("55df103deaf68dc4"), Hex.decode("96d872b9122c5e74"), Hex.decode("9c960bb9662ce6de")});
    }
}

