/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidWrappingException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Key;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyUnwrapper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedKeyWrapOperatorFactory<T extends Parameters, K extends Key>
implements KeyWrapOperatorFactory<T, K> {
    GuardedKeyWrapOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public KeyWrapper<T> createKeyWrapper(K k, T t) {
        return new GuardedWrapper(this, k, t, null);
    }

    @Override
    public KeyUnwrapper<T> createKeyUnwrapper(K k, T t) {
        return new GuardedUnwrapper(this, t.getAlgorithm(), t, this.createWrapper(false, k, t, null));
    }

    protected abstract Wrapper createWrapper(boolean var1, K var2, T var3, SecureRandom var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuardedUnwrapper
    implements KeyUnwrapper<T> {
        private final Algorithm algorithm;
        private final T parameters;
        private final Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedUnwrapper(Algorithm algorithm, T t, Wrapper wrapper) {
            this.this$0 = var1_1;
            this.algorithm = algorithm;
            this.parameters = t;
            this.wrapper = wrapper;
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
            Utils.approveModeCheck(this.algorithm);
            try {
                return this.wrapper.unwrap(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuardedWrapper
    implements KeyWrapperUsingSecureRandom<T> {
        private final Algorithm algorithm;
        private final K key;
        private final T parameters;
        private final SecureRandom random;
        private Wrapper wrapper;
        final /* synthetic */ GuardedKeyWrapOperatorFactory this$0;

        GuardedWrapper(K k, T t, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.algorithm = t.getAlgorithm();
            this.key = k;
            this.parameters = t;
            this.random = secureRandom;
        }

        void setUp() {
            if (this.wrapper == null) {
                this.wrapper = this.this$0.createWrapper(true, this.key, this.parameters, this.random);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public byte[] wrap(byte[] byArray, int n, int n2) {
            Utils.approveModeCheck(this.algorithm);
            this.setUp();
            return this.wrapper.wrap(byArray, n, n2);
        }

        @Override
        public KeyWrapperUsingSecureRandom<T> withSecureRandom(SecureRandom secureRandom) {
            return new GuardedWrapper(this.this$0, this.key, this.parameters, secureRandom);
        }
    }
}

