/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DsaKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DsaParametersGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DsaSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSignatureOperatorUsingSecureRandomFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.HMacDsaKCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.NullDigest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.RandomDsaKCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Register;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SelfTestExecutor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.ConsistencyTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Properties;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

public final class DSA {
    public static final Algorithm ALGORITHM = FipsDSA.ALGORITHM;
    public static final Parameters DSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DSA), FipsSHS.Algorithm.SHA1);
    public static final Parameters DDSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DDSA), FipsSHS.Algorithm.SHA1);

    private DSA() {
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate(ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner dsaSigner = new DsaSigner(new RandomDsaKCalculator());
                dsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = dsaSigner.generateSignature(byArray);
                dsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    private static DsaParameters getDomainParams(DSADomainParameters dSADomainParameters) {
        return new DsaParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(asymmetricDSAPrivateKey.getX(), net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSA.getDomainParams(asymmetricDSAPrivateKey.getDomainParameters()));
            }
        });
    }

    public static final class DomainGenParameters
    extends GeneralParameters {
        private final int strength;
        private final int certainty;

        public DomainGenParameters(int n) {
            this(n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public DomainGenParameters(int n, int n2) {
            super(ALGORITHM);
            this.strength = n;
            this.certainty = n2;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved generator in approved only mode.");
            }
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DSADomainParameters generateDomainParameters() {
            DsaParametersGenerator dsaParametersGenerator = this.parameters.strength <= 1024 ? new DsaParametersGenerator() : new DsaParametersGenerator(Register.createDigest(FipsSHS.Algorithm.SHA256));
            if (this.parameters.strength == 1024) {
                if (Properties.isOverrideSet("net.snowflake.client.jdbc.internal.org.bouncycastle.dsa.FIPS186-2for1024bits")) {
                    dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
                } else {
                    DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(1024, 160, this.parameters.certainty, this.random);
                    dsaParametersGenerator.init(dsaParameterGenerationParameters);
                }
            } else if (this.parameters.strength > 1024) {
                DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(this.parameters.strength, 256, this.parameters.certainty, this.random);
                dsaParametersGenerator.init(dsaParameterGenerationParameters);
            } else {
                dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
            }
            DsaParameters dsaParameters = dsaParametersGenerator.generateParameters();
            DsaValidationParameters dsaValidationParameters = dsaParameters.getValidationParameters();
            return new DSADomainParameters(dsaParameters.getP(), dsaParameters.getQ(), dsaParameters.getG(), new DSAValidationParameters(dsaValidationParameters.getSeed(), dsaValidationParameters.getCounter(), dsaValidationParameters.getUsageIndex()));
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(Parameters parameters, DSADomainParameters dSADomainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = dSADomainParameters;
        }

        public KeyGenParameters(DSADomainParameters dSADomainParameters) {
            super(ALGORITHM);
            this.domainParameters = dSADomainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(secureRandom, net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSA.validateKeyPair(asymmetricCipherKeyPair);
            DsaPublicKeyParameters dsaPublicKeyParameters = (DsaPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DsaPrivateKeyParameters dsaPrivateKeyParameters = (DsaPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey((Algorithm)t, this.domainParameters, dsaPublicKeyParameters.getY()), new AsymmetricDSAPrivateKey((Algorithm)t, this.domainParameters, dsaPrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSignatureOperatorUsingSecureRandomFactory<Parameters> {
        @Override
        protected OutputSignerUsingSecureRandom<Parameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)asymmetricPrivateKey;
            final DsaPrivateKeyParameters dsaPrivateKeyParameters = net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSA.getLwKey(asymmetricDSAPrivateKey);
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(dsaPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)asymmetricPublicKey;
            DsaPublicKeyParameters dsaPublicKeyParameters = new DsaPublicKeyParameters(asymmetricDSAPublicKey.getY(), net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSA.getDomainParams(asymmetricDSAPublicKey.getDomainParameters()));
            dsaSigner.init(false, dsaPublicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }
    }

    public static final class Parameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            if (generalAlgorithm.basicVariation() == Variations.DDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("DDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        DSA,
        DDSA;

    }
}

