/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.IllegalKeyException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricSecretKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ARC4Engine;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.CipherKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSymmetricStreamOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.PrivilegedUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SelfTestExecutor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.VariantKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.StreamCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

public final class ARC4 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ARC4");
    public static final Parameters STREAM = new Parameters();
    private static final EngineProvider ENGINE_PROVIDER;

    private ARC4() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (ARC4.invalidKeySize(n)) {
            throw new IllegalKeyException("Key the wrong size for ARC4");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n) {
        return n < 40 || n > 2048;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    implements net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.EngineProvider<ARC4Engine> {
        private EngineProvider() {
        }

        @Override
        public ARC4Engine createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new ARC4Engine(), new VariantKatTest<ARC4Engine>(){

                @Override
                public void evaluate(ARC4Engine aRC4Engine) {
                    byte[] byArray = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] byArray2 = Hex.decode("1035d3faeefacf4afea5343bc4e8876c");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    aRC4Engine.init(true, keyParameterImpl);
                    aRC4Engine.processBytes(byArray, 0, byArray.length, byArray3, 0);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    aRC4Engine.init(false, keyParameterImpl);
                    aRC4Engine.processBytes(byArray3, 0, byArray3.length, byArray3, 0);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm = ALGORITHM;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n, SecureRandom secureRandom) {
            if (ARC4.invalidKeySize(n)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n + "]: RC4");
            }
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricStreamOperatorFactory<Parameters> {
        @Override
        protected StreamCipher createCipher(boolean bl, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            ARC4Engine aRC4Engine = ENGINE_PROVIDER.createEngine();
            KeyParameter keyParameter = Utils.getKeyParameter(ARC4.validateKey(symmetricKey, parameters.getAlgorithm()));
            aRC4Engine.init(bl, keyParameter);
            return aRC4Engine;
        }
    }

    public static final class Parameters
    extends GeneralParameters {
        Parameters() {
            super(ALGORITHM);
        }
    }
}

