/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import java.math.BigDecimal;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ZeroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.AbstractStructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractPromotableFieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionListWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.DecimalHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class PromotableWriter
extends AbstractPromotableFieldWriter {
    private final AbstractStructVector parentContainer;
    private final ListVector listVector;
    private final NullableStructWriterFactory nullableStructWriterFactory;
    private int position;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private Types.MinorType type;
    private ArrowType arrowType;
    private ValueVector vector;
    private UnionVector unionVector;
    private State state;
    private FieldWriter writer;

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer) {
        this(v, parentContainer, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer, NullableStructWriterFactory nullableStructWriterFactory) {
        this.parentContainer = parentContainer;
        this.listVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, ListVector listVector) {
        this(v, listVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, ListVector listVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.listVector = listVector;
        this.parentContainer = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    private void init(ValueVector v) {
        if (v instanceof UnionVector) {
            this.state = State.UNION;
            this.unionVector = (UnionVector)v;
            this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        } else if (v instanceof ZeroVector) {
            this.state = State.UNTYPED;
        } else {
            this.setWriter(v);
        }
    }

    private void setWriter(ValueVector v) {
        this.setWriter(v, null);
    }

    private void setWriter(ValueVector v, ArrowType arrowType) {
        this.state = State.SINGLE;
        this.vector = v;
        this.type = v.getMinorType();
        this.arrowType = arrowType;
        switch (this.type) {
            case STRUCT: {
                this.writer = this.nullableStructWriterFactory.build((StructVector)this.vector);
                break;
            }
            case LIST: {
                this.writer = new UnionListWriter((ListVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            case UNION: {
                this.writer = new UnionWriter((UnionVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            default: {
                this.writer = this.type.getNewFieldWriter(this.vector);
            }
        }
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        FieldWriter w = this.getWriter();
        if (w == null) {
            this.position = index;
        } else {
            w.setPosition(index);
        }
    }

    @Override
    protected FieldWriter getWriter(Types.MinorType type) {
        return this.getWriter(type, null);
    }

    protected FieldWriter getWriter(Types.MinorType type, ArrowType arrowType) {
        if (this.state == State.UNION) {
            ((UnionWriter)this.writer).getWriter(type);
        } else if (this.state == State.UNTYPED) {
            if (type == null) {
                return null;
            }
            if (arrowType == null) {
                arrowType = type.getType();
            }
            Object v = this.listVector.addOrGetVector(FieldType.nullable(arrowType)).getVector();
            v.allocateNew();
            this.setWriter((ValueVector)v, arrowType);
            this.writer.setPosition(this.position);
        } else if (type != this.type) {
            this.promoteToUnion();
            ((UnionWriter)this.writer).getWriter(type);
        }
        return this.writer;
    }

    @Override
    public boolean isEmptyStruct() {
        return this.writer.isEmptyStruct();
    }

    @Override
    protected FieldWriter getWriter() {
        return this.writer;
    }

    private FieldWriter promoteToUnion() {
        String name = this.vector.getField().getName();
        TransferPair tp = this.vector.getTransferPair(this.vector.getMinorType().name().toLowerCase(), this.vector.getAllocator());
        tp.transfer();
        if (this.parentContainer != null) {
            this.unionVector = this.parentContainer.addOrGetUnion(name);
            this.unionVector.allocateNew();
        } else if (this.listVector != null) {
            this.unionVector = this.listVector.promoteToUnion();
        }
        this.unionVector.addVector((FieldVector)tp.getTo());
        this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        this.writer.setPosition(this.idx());
        for (int i = 0; i <= this.idx(); ++i) {
            this.unionVector.setType(i, this.vector.getMinorType());
        }
        this.vector = null;
        this.state = State.UNION;
        return this.writer;
    }

    @Override
    public void write(DecimalHolder holder) {
        if (this.arrowType == null) {
            this.arrowType = new ArrowType.Decimal(38, holder.scale);
        }
        this.getWriter(Types.MinorType.DECIMAL, this.arrowType).write(holder);
    }

    @Override
    public void writeDecimal(int start, ArrowBuf buffer) {
        if (this.arrowType == null) {
            throw new IllegalStateException("Cannot infer decimal scale and precision");
        }
        this.getWriter(Types.MinorType.DECIMAL, this.arrowType).writeDecimal(start, buffer);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (this.arrowType == null) {
            this.arrowType = new ArrowType.Decimal(38, value.scale());
        }
        this.getWriter(Types.MinorType.DECIMAL, this.arrowType).writeDecimal(value);
    }

    @Override
    public void allocate() {
        this.getWriter().allocate();
    }

    @Override
    public void clear() {
        this.getWriter().clear();
    }

    @Override
    public Field getField() {
        return this.getWriter().getField();
    }

    @Override
    public int getValueCapacity() {
        return this.getWriter().getValueCapacity();
    }

    @Override
    public void close() throws Exception {
        this.getWriter().close();
    }

    private static enum State {
        UNTYPED,
        SINGLE,
        UNION;

    }
}

