/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferLayout;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TypeLayout;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class VectorUnloader {
    private final VectorSchemaRoot root;
    private final boolean includeNullCount;
    private final boolean alignBuffers;

    public VectorUnloader(VectorSchemaRoot root) {
        this(root, true, true);
    }

    public VectorUnloader(VectorSchemaRoot root, boolean includeNullCount, boolean alignBuffers) {
        this.root = root;
        this.includeNullCount = includeNullCount;
        this.alignBuffers = alignBuffers;
    }

    public ArrowRecordBatch getRecordBatch() {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (FieldVector vector : this.root.getFieldVectors()) {
            this.appendNodes(vector, nodes, buffers);
        }
        return new ArrowRecordBatch(this.root.getRowCount(), nodes, buffers, this.alignBuffers);
    }

    private void appendNodes(FieldVector vector, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        nodes.add(new ArrowFieldNode(vector.getValueCount(), this.includeNullCount ? vector.getNullCount() : -1));
        List<ArrowBuf> fieldBuffers = vector.getFieldBuffers();
        List<BufferLayout.BufferType> expectedBuffers = TypeLayout.getTypeLayout(vector.getField().getType()).getBufferTypes();
        if (fieldBuffers.size() != expectedBuffers.size()) {
            throw new IllegalArgumentException(String.format("wrong number of buffers for field %s in vector %s. found: %s", vector.getField(), vector.getClass().getSimpleName(), fieldBuffers));
        }
        buffers.addAll(fieldBuffers);
        for (FieldVector child : vector.getChildrenFromFields()) {
            this.appendNodes(child, nodes, buffers);
        }
    }
}

