/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.Float8ReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.Float8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class Float8Vector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 8;
    private final FieldReader reader = new Float8ReaderImpl(this);

    public Float8Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.FLOAT8.getType()), allocator);
    }

    public Float8Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 8);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FLOAT8;
    }

    public double get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getDouble(index * 8);
    }

    public void get(int index, NullableFloat8Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getDouble(index * 8);
    }

    @Override
    public Double getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getDouble(index * 8);
    }

    public void copyFrom(int fromIndex, int thisIndex, Float8Vector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        double value = from.valueBuffer.getDouble(fromIndex * 8);
        this.valueBuffer.setDouble(thisIndex * 8, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Float8Vector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, double value) {
        this.valueBuffer.setDouble(index * 8, value);
    }

    public void set(int index, double value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableFloat8Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, Float8Holder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, double value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableFloat8Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, Float8Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, double value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, double value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static double get(ArrowBuf buffer, int index) {
        return buffer.getDouble(index * 8);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Float8Vector)to);
    }

    private class TransferImpl
    implements TransferPair {
        Float8Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new Float8Vector(ref, Float8Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Float8Vector to) {
            this.to = to;
        }

        @Override
        public Float8Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Float8Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Float8Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Float8Vector.this);
        }
    }
}

