/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.memory;

import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.LowCostIdentityHashMap;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.RootAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ValueWithKeyIncluded;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.HistoricalLog;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import net.snowflake.client.jdbc.internal.io.netty.buffer.PooledByteBufAllocatorL;
import net.snowflake.client.jdbc.internal.io.netty.buffer.UnsafeDirectLittleEndian;

public class AllocationManager {
    private static final AtomicLong MANAGER_ID_GENERATOR = new AtomicLong(0L);
    private static final AtomicLong LEDGER_ID_GENERATOR = new AtomicLong(0L);
    private static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL();
    static final UnsafeDirectLittleEndian EMPTY = AllocationManager.INNER_ALLOCATOR.empty;
    static final long CHUNK_SIZE = INNER_ALLOCATOR.getChunkSize();
    private final RootAllocator root;
    private final long allocatorManagerId = MANAGER_ID_GENERATOR.incrementAndGet();
    private final int size;
    private final UnsafeDirectLittleEndian underlying;
    private final LowCostIdentityHashMap<BaseAllocator, BufferLedger> map = new LowCostIdentityHashMap();
    private final long amCreationTime = System.nanoTime();
    private volatile BufferLedger owningLedger;
    private volatile long amDestructionTime = 0L;

    AllocationManager(BaseAllocator accountingAllocator, int size) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.root;
        this.underlying = INNER_ALLOCATOR.allocate(size);
        this.owningLedger = this.associate(accountingAllocator, false);
        this.size = this.underlying.capacity();
    }

    BufferLedger associate(BaseAllocator allocator) {
        return this.associate(allocator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferLedger associate(BaseAllocator allocator, boolean retain) {
        allocator.assertOpen();
        if (this.root != allocator.root) {
            throw new IllegalStateException("A buffer can only be associated between two allocators that share the same root.");
        }
        AllocationManager allocationManager = this;
        synchronized (allocationManager) {
            BufferLedger oldLedger;
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.inc();
                }
                return ledger;
            }
            ledger = new BufferLedger(allocator);
            if (retain) {
                ledger.inc();
            }
            Preconditions.checkArgument((oldLedger = this.map.put(ledger)) == null);
            allocator.associateLedger(ledger);
            return ledger;
        }
    }

    private void release(BufferLedger ledger) {
        BaseAllocator allocator = ledger.getAllocator();
        allocator.assertOpen();
        BufferLedger oldLedger = this.map.remove(allocator);
        oldLedger.allocator.dissociateLedger(oldLedger);
        if (oldLedger == this.owningLedger) {
            if (this.map.isEmpty()) {
                oldLedger.allocator.releaseBytes(this.size);
                this.underlying.release();
                this.amDestructionTime = System.nanoTime();
                this.owningLedger = null;
            } else {
                BufferLedger newLedger = this.map.getNextValue();
                oldLedger.transferBalance(newLedger);
            }
        } else if (this.map.isEmpty()) {
            throw new IllegalStateException("The final removal of a ledger should be connected to the owning ledger.");
        }
    }

    static /* synthetic */ AtomicLong access$400() {
        return LEDGER_ID_GENERATOR;
    }

    public class BufferLedger
    implements ValueWithKeyIncluded<BaseAllocator> {
        private final IdentityHashMap<ArrowBuf, Object> buffers = BaseAllocator.DEBUG ? new IdentityHashMap() : null;
        private final long ledgerId = AllocationManager.access$400().incrementAndGet();
        private final AtomicInteger bufRefCnt = new AtomicInteger(0);
        private final long lCreationTime = System.nanoTime();
        private final BaseAllocator allocator;
        private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "BufferLedger[%d]", 1) : null;
        private volatile long lDestructionTime = 0L;

        private BufferLedger(BaseAllocator allocator) {
            this.allocator = allocator;
        }

        private BaseAllocator getAllocator() {
            return this.allocator;
        }

        @Override
        public BaseAllocator getKey() {
            return this.allocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean transferBalance(BufferLedger target) {
            Preconditions.checkNotNull(target);
            Preconditions.checkArgument(this.allocator.root == target.allocator.root, "You can only transfer between two allocators that share the same root.");
            this.allocator.assertOpen();
            target.allocator.assertOpen();
            if (target == this) {
                return true;
            }
            AllocationManager allocationManager = AllocationManager.this;
            synchronized (allocationManager) {
                if (AllocationManager.this.owningLedger != this) {
                    return true;
                }
                if (BaseAllocator.DEBUG) {
                    this.historicalLog.recordEvent("transferBalance(%s)", target.allocator.name);
                    target.historicalLog.recordEvent("incoming(from %s)", ((AllocationManager)AllocationManager.this).owningLedger.allocator.name);
                }
                boolean overlimit = target.allocator.forceAllocate(AllocationManager.this.size);
                this.allocator.releaseBytes(AllocationManager.this.size);
                AllocationManager.this.owningLedger = target;
                return overlimit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
            BaseAllocator.indent(sb, indent).append("ledger[").append(this.ledgerId).append("] allocator: ").append(this.allocator.name).append("), isOwning: ").append(AllocationManager.this.owningLedger == this).append(", size: ").append(AllocationManager.this.size).append(", references: ").append(this.bufRefCnt.get()).append(", life: ").append(this.lCreationTime).append("..").append(this.lDestructionTime).append(", allocatorManager: [").append(AllocationManager.this.allocatorManagerId).append(", life: ").append(AllocationManager.this.amCreationTime).append("..").append(AllocationManager.this.amDestructionTime);
            if (!BaseAllocator.DEBUG) {
                sb.append("]\n");
            } else {
                IdentityHashMap<ArrowBuf, Object> identityHashMap = this.buffers;
                synchronized (identityHashMap) {
                    sb.append("] holds ").append(this.buffers.size()).append(" buffers. \n");
                    for (ArrowBuf buf : this.buffers.keySet()) {
                        buf.print(sb, indent + 2, verbosity);
                        sb.append('\n');
                    }
                }
            }
        }

        private void inc() {
            this.bufRefCnt.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrement(int decrement) {
            int outcome;
            this.allocator.assertOpen();
            AllocationManager allocationManager = AllocationManager.this;
            synchronized (allocationManager) {
                outcome = this.bufRefCnt.addAndGet(-decrement);
                if (outcome == 0) {
                    this.lDestructionTime = System.nanoTime();
                    AllocationManager.this.release(this);
                }
            }
            return outcome;
        }

        public BufferLedger getLedgerForAllocator(BufferAllocator allocator) {
            return AllocationManager.this.associate((BaseAllocator)allocator);
        }

        public ArrowBuf newArrowBuf(int offset, int length) {
            this.allocator.assertOpen();
            return this.newArrowBuf(offset, length, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrowBuf newArrowBuf(int offset, int length, BufferManager manager) {
            this.allocator.assertOpen();
            ArrowBuf buf = new ArrowBuf(this.bufRefCnt, this, AllocationManager.this.underlying, manager, this.allocator.getAsByteBufAllocator(), offset, length, false);
            if (BaseAllocator.DEBUG) {
                this.historicalLog.recordEvent("ArrowBuf(BufferLedger, BufferAllocator[%s], UnsafeDirectLittleEndian[identityHashCode == %d](%s)) => ledger hc == %d", this.allocator.name, System.identityHashCode(buf), buf.toString(), System.identityHashCode(this));
                IdentityHashMap<ArrowBuf, Object> identityHashMap = this.buffers;
                synchronized (identityHashMap) {
                    this.buffers.put(buf, null);
                }
            }
            return buf;
        }

        public int getSize() {
            return AllocationManager.this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAccountedSize() {
            AllocationManager allocationManager = AllocationManager.this;
            synchronized (allocationManager) {
                if (AllocationManager.this.owningLedger == this) {
                    return AllocationManager.this.size;
                }
                return 0;
            }
        }

        UnsafeDirectLittleEndian getUnderlying() {
            return AllocationManager.this.underlying;
        }

        boolean isOwningLedger() {
            return this == AllocationManager.this.owningLedger;
        }
    }
}

