/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.io.netty.buffer;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.io.netty.buffer.MutableWrappedByteBuf;

public class ExpandableByteBuf
extends MutableWrappedByteBuf {
    private final BufferAllocator allocator;

    public ExpandableByteBuf(ByteBuf buffer, BufferAllocator allocator) {
        super(buffer);
        this.allocator = allocator;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return new ExpandableByteBuf(this.buffer.copy(index, length), this.allocator);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        if (newCapacity > this.capacity()) {
            ArrowBuf newBuf = this.allocator.buffer(newCapacity);
            ((ByteBuf)newBuf).writeBytes(this.buffer, 0, this.buffer.capacity());
            ((ByteBuf)newBuf).readerIndex(this.buffer.readerIndex());
            ((ByteBuf)newBuf).writerIndex(this.buffer.writerIndex());
            this.buffer.release();
            this.buffer = newBuf;
            return newBuf;
        }
        return super.capacity(newCapacity);
    }
}

