/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class ThreeFieldStructToTimestampTZConverter
extends AbstractArrowVectorConverter {
    private StructVector structVector;
    private BigIntVector epochs;
    private IntVector fractions;
    private IntVector timeZoneIndices;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public ThreeFieldStructToTimestampTZConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIMESTAMP_LTZ.name(), fieldVector, columnIndex, context);
        this.structVector = (StructVector)fieldVector;
        this.epochs = this.structVector.getChild("EPOCH", BigIntVector.class);
        this.fractions = this.structVector.getChild("FRACTION", IntVector.class);
        this.timeZoneIndices = this.structVector.getChild("TIMEZONE", IntVector.class);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimestampTZFormatter() == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.context.getSession(), new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp LTZ formatter"), null, null);
        }
        Timestamp ts = this.toTimestamp(index, TimeZone.getDefault());
        return ts == null ? null : this.context.getTimestampTZFormatter().format(ts, this.timeZone, this.context.getScale(this.columnIndex));
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toTimestamp(index, TimeZone.getDefault());
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        return this.epochs.isNull(index) ? null : this.getTimestamp(index, tz);
    }

    private Timestamp getTimestamp(int index, TimeZone tz) throws SFException {
        long epoch = this.epochs.getDataBuffer().getLong(index * 8);
        int fraction = this.fractions.getDataBuffer().getInt(index * 4);
        int timeZoneIndex = this.timeZoneIndices.getDataBuffer().getInt(index * 4);
        if (ArrowResultUtil.isTimestampOverflow(epoch)) {
            return null;
        }
        Timestamp ts = ArrowResultUtil.createTimestamp(epoch, fraction);
        this.timeZone = this.context.getResultVersion() > 0L ? SFTimestamp.convertTimezoneIndexToTimeZone(timeZoneIndex) : TimeZone.getTimeZone("UTC");
        Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(ts);
        return adjustedTimestamp;
    }

    @Override
    public Date toDate(int index) throws SFException {
        if (this.epochs.isNull(index)) {
            return null;
        }
        Timestamp ts = this.getTimestamp(index, TimeZone.getDefault());
        return ts == null ? null : new Date(ts.getTime());
    }

    @Override
    public Time toTime(int index) throws SFException {
        Timestamp ts = this.toTimestamp(index, TimeZone.getDefault());
        return ts == null ? null : new Time(ts.getTime());
    }
}

