/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class DoubleToRealConverter
extends AbstractArrowVectorConverter {
    private Float8Vector float8Vector;

    public DoubleToRealConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.REAL.name(), fieldVector, columnIndex, context);
        this.float8Vector = (Float8Vector)fieldVector;
    }

    @Override
    public double toDouble(int index) {
        if (this.float8Vector.isNull(index)) {
            return 0.0;
        }
        return this.float8Vector.getDataBuffer().getDouble(index * 8);
    }

    @Override
    public float toFloat(int index) {
        return (float)this.toDouble(index);
    }

    @Override
    public Object toObject(int index) {
        return this.isNull(index) ? null : Double.valueOf(this.toDouble(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : String.valueOf(this.toDouble(index));
    }
}

