/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;

public class SFStatementMetaData {
    private SFResultSetMetaData resultSetMetaData;
    private int numberOfBinds;
    private final SFStatementType statementType;
    private final boolean arrayBindSupported;
    private List<MetaDataOfBinds> metaDataOfBinds;

    SFStatementMetaData(SFResultSetMetaData resultSetMetaData, SFStatementType statementType, int numberOfBinds, boolean arrayBindSupported, List<MetaDataOfBinds> metaDataOfBinds) {
        this.resultSetMetaData = resultSetMetaData;
        this.statementType = statementType;
        this.numberOfBinds = numberOfBinds;
        this.arrayBindSupported = arrayBindSupported;
        this.metaDataOfBinds = metaDataOfBinds;
    }

    public SFResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public void setResultSetMetaData(SFResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public MetaDataOfBinds getMetaDataForBindParam(int param) throws SQLException {
        if (param < 1 || param > this.numberOfBinds) {
            throw new SnowflakeSQLException("22003", ErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.getMessageCode(), param, this.numberOfBinds);
        }
        if (this.numberOfBinds != this.metaDataOfBinds.size() || this.metaDataOfBinds.size() == 0) {
            throw new SnowflakeSQLException("02000", ErrorCode.NO_VALID_DATA.getMessageCode());
        }
        return this.metaDataOfBinds.get(param - 1);
    }

    public void setNumberOfBinds(int numberOfBinds) {
        this.numberOfBinds = numberOfBinds;
    }

    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    public SFStatementType getStatementType() {
        return this.statementType;
    }

    public static SFStatementMetaData emptyMetaData() {
        return new SFStatementMetaData(new SFResultSetMetaData(0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null), SFStatementType.UNKNOWN, 0, false, new ArrayList<MetaDataOfBinds>());
    }
}

