/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.AllocationManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowByteBufAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BoundsChecking;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.HistoricalLog;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.io.netty.buffer.AbstractByteBuf;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ByteBufUtil;
import net.snowflake.client.jdbc.internal.io.netty.buffer.UnsafeDirectLittleEndian;
import net.snowflake.client.jdbc.internal.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowBuf
extends AbstractByteBuf
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ArrowBuf.class);
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private static final int LOG_BYTES_PER_ROW = 10;
    private final long id = idGenerator.incrementAndGet();
    private final AtomicInteger refCnt;
    private final UnsafeDirectLittleEndian udle;
    private final long addr;
    private final int offset;
    private final AllocationManager.BufferLedger ledger;
    private final BufferManager bufManager;
    private final ArrowByteBufAllocator alloc;
    private final boolean isEmpty;
    private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "ArrowBuf[%d]", this.id) : null;
    private volatile int length;

    public ArrowBuf(AtomicInteger refCnt, AllocationManager.BufferLedger ledger, UnsafeDirectLittleEndian byteBuf, BufferManager manager, ArrowByteBufAllocator alloc, int offset, int length, boolean isEmpty) {
        super(byteBuf.maxCapacity());
        this.refCnt = refCnt;
        this.udle = byteBuf;
        this.isEmpty = isEmpty;
        this.bufManager = manager;
        this.alloc = alloc;
        this.addr = byteBuf.memoryAddress() + (long)offset;
        this.ledger = ledger;
        this.length = length;
        this.offset = offset;
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("create()", new Object[0]);
        }
    }

    public static String bufferState(ByteBuf buf) {
        int cap = buf.capacity();
        int mcap = buf.maxCapacity();
        int ri = buf.readerIndex();
        int rb = buf.readableBytes();
        int wi = buf.writerIndex();
        int wb = buf.writableBytes();
        return String.format("cap/max: %d/%d, ri: %d, rb: %d, wi: %d, wb: %d", cap, mcap, ri, rb, wi, wb);
    }

    public ArrowBuf reallocIfNeeded(int size) {
        Preconditions.checkArgument(size >= 0, "reallocation size must be non-negative");
        if (this.capacity() >= size) {
            return this;
        }
        if (this.bufManager != null) {
            return this.bufManager.replace(this, size);
        }
        throw new UnsupportedOperationException("Realloc is only available in the context of an operator's UDFs");
    }

    @Override
    public int refCnt() {
        if (this.isEmpty) {
            return 1;
        }
        return this.refCnt.get();
    }

    private long addr(int index) {
        return this.addr + (long)index;
    }

    private final void checkIndexD(int index, int fieldLength) {
        this.ensureAccessible();
        if (fieldLength < 0) {
            throw new IllegalArgumentException("length: " + fieldLength + " (expected: >= 0)");
        }
        if (index < 0 || index > this.capacity() - fieldLength) {
            if (BaseAllocator.DEBUG) {
                this.historicalLog.logHistory(logger);
            }
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    public void checkBytes(int start, int end) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(start, end - start);
        }
    }

    private void chk(int index, int width) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(index, width);
        }
    }

    private void ensure(int width) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.ensureWritable(width);
        }
    }

    public ArrowBuf retain(BufferAllocator target) {
        if (this.isEmpty) {
            return this;
        }
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%s)", target.getName());
        }
        AllocationManager.BufferLedger otherLedger = this.ledger.getLedgerForAllocator(target);
        ArrowBuf newArrowBuf = otherLedger.newArrowBuf(this.offset, this.length, null);
        newArrowBuf.readerIndex(this.readerIndex);
        newArrowBuf.writerIndex(this.writerIndex);
        return newArrowBuf;
    }

    public TransferResult transferOwnership(BufferAllocator target) {
        if (this.isEmpty) {
            return new TransferResult(true, this);
        }
        AllocationManager.BufferLedger otherLedger = this.ledger.getLedgerForAllocator(target);
        ArrowBuf newBuf = otherLedger.newArrowBuf(this.offset, this.length, null);
        newBuf.setIndex(this.readerIndex, this.writerIndex);
        boolean allocationFit = this.ledger.transferBalance(otherLedger);
        return new TransferResult(allocationFit, newBuf);
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        if (this.isEmpty) {
            return false;
        }
        if (decrement < 1) {
            throw new IllegalStateException(String.format("release(%d) argument is not positive. Buffer Info: %s", decrement, this.toVerboseString()));
        }
        int refCnt = this.ledger.decrement(decrement);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("release(%d). original value: %d", decrement, refCnt + decrement);
        }
        if (refCnt < 0) {
            throw new IllegalStateException(String.format("ArrowBuf[%d] refCnt has gone negative. Buffer Info: %s", this.id, this.toVerboseString()));
        }
        return refCnt == 0;
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public synchronized ArrowBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0);
        if (newCapacity < this.length) {
            this.length = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    @Override
    public ArrowByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ArrowBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    public ByteBuf unwrap() {
        return this.udle;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public ByteBuf readBytes(int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf readSlice(int length) {
        ArrowBuf slice = this.slice(this.readerIndex(), length);
        this.readerIndex(this.readerIndex() + length);
        return slice;
    }

    @Override
    public ByteBuf copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ArrowBuf slice(int index, int length) {
        if (this.isEmpty) {
            return this;
        }
        Preconditions.checkPositionIndex(index, this.length);
        Preconditions.checkPositionIndex(index + length, this.length);
        ArrowBuf newBuf = this.ledger.newArrowBuf(this.offset + index, length);
        newBuf.writerIndex(length);
        return newBuf;
    }

    @Override
    public ArrowBuf duplicate() {
        return this.slice(0, this.length);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return this.udle.nioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.udle.internalNioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{this.nioBuffer()};
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public boolean hasArray() {
        return this.udle.hasArray();
    }

    @Override
    public byte[] array() {
        return this.udle.array();
    }

    @Override
    public int arrayOffset() {
        return this.udle.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.addr;
    }

    @Override
    public String toString() {
        return String.format("ArrowBuf[%d], udle: [%d %d..%d]", this.id, this.udle.id, this.offset, this.offset + this.capacity());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        return ByteBufUtil.decodeString(this, index, length, charset);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public ArrowBuf retain(int increment) {
        int originalReferenceCount;
        Preconditions.checkArgument(increment > 0, "retain(%d) argument is not positive", increment);
        if (this.isEmpty) {
            return this;
        }
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%d)", increment);
        }
        Preconditions.checkArgument((originalReferenceCount = this.refCnt.getAndAdd(increment)) > 0);
        return this;
    }

    @Override
    public ArrowBuf retain() {
        return this.retain(1);
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public long getLong(int index) {
        this.chk(index, 8);
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public long getLongLE(int index) {
        this.chk(index, 8);
        long v = PlatformDependent.getLong(this.addr(index));
        return Long.reverseBytes(v);
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        this.chk(index, 4);
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public int getIntLE(int index) {
        this.chk(index, 4);
        int v = PlatformDependent.getInt(this.addr(index));
        return Integer.reverseBytes(v);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getShort(int index) {
        this.chk(index, 2);
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public short getShortLE(int index) {
        short v = PlatformDependent.getShort(this.addr(index));
        return Short.reverseBytes(v);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.chk(index, 3);
        long addr = this.addr(index);
        return (PlatformDependent.getByte(addr) & 0xFF) << 16 | PlatformDependent.getShort(addr + 1L) & 0xFFFF;
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        this.chk(index, 3);
        long addr = this.addr(index);
        return PlatformDependent.getByte(addr) & 0xFF | (Short.reverseBytes(PlatformDependent.getShort(addr + 1L)) & 0xFFFF) << 8;
    }

    @Override
    public ArrowBuf setShort(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ByteBuf setShortLE(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), Short.reverseBytes((short)value));
        return this;
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.chk(index, 3);
        long addr = this.addr(index);
        PlatformDependent.putByte(addr, (byte)(value >>> 16));
        PlatformDependent.putShort(addr + 1L, (short)value);
        return this;
    }

    @Override
    public ByteBuf setMediumLE(int index, int value) {
        this.chk(index, 3);
        long addr = this.addr(index);
        PlatformDependent.putByte(addr, (byte)value);
        PlatformDependent.putShort(addr + 1L, Short.reverseBytes((short)(value >>> 8)));
        return this;
    }

    @Override
    public ArrowBuf setInt(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setIntLE(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), Integer.reverseBytes(value));
        return this;
    }

    @Override
    public ArrowBuf setLong(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setLongLE(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), Long.reverseBytes(value));
        return this;
    }

    @Override
    public ArrowBuf setChar(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ArrowBuf setFloat(int index, float value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ArrowBuf setDouble(int index, double value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ArrowBuf writeShort(int value) {
        this.ensure(2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ArrowBuf writeInt(int value) {
        this.ensure(4);
        PlatformDependent.putInt(this.addr(this.writerIndex), value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ArrowBuf writeLong(long value) {
        this.ensure(8);
        PlatformDependent.putLong(this.addr(this.writerIndex), value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ArrowBuf writeChar(int value) {
        this.ensure(2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ArrowBuf writeFloat(float value) {
        this.ensure(4);
        PlatformDependent.putInt(this.addr(this.writerIndex), Float.floatToRawIntBits(value));
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ArrowBuf writeDouble(double value) {
        this.ensure(8);
        PlatformDependent.putLong(this.addr(this.writerIndex), Double.doubleToRawLongBits(value));
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ArrowBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.udle.getBytes(index + this.offset, dst, dstIndex, length);
        return this;
    }

    @Override
    public ArrowBuf getBytes(int index, ByteBuffer dst) {
        this.udle.getBytes(index + this.offset, dst);
        return this;
    }

    @Override
    public ArrowBuf setByte(int index, int value) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }

    public void setByte(int index, byte b) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), b);
    }

    public void writeByteUnsafe(byte b) {
        PlatformDependent.putByte(this.addr(this.readerIndex), b);
        ++this.readerIndex;
    }

    @Override
    protected byte _getByte(int index) {
        return this.getByte(index);
    }

    @Override
    protected short _getShort(int index) {
        return this.getShort(index);
    }

    @Override
    protected short _getShortLE(int index) {
        return this.getShortLE(index);
    }

    @Override
    protected int _getInt(int index) {
        return this.getInt(index);
    }

    @Override
    protected int _getIntLE(int index) {
        return this.getIntLE(index);
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return this.getUnsignedMedium(index);
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        return this.getUnsignedMediumLE(index);
    }

    @Override
    protected long _getLong(int index) {
        return this.getLong(index);
    }

    @Override
    protected long _getLongLE(int index) {
        return this.getLongLE(index);
    }

    @Override
    protected void _setByte(int index, int value) {
        this.setByte(index, value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.setShort(index, value);
    }

    @Override
    protected void _setShortLE(int index, int value) {
        this.setShortLE(index, value);
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.setMedium(index, value);
    }

    @Override
    protected void _setMediumLE(int index, int value) {
        this.setMediumLE(index, value);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.setInt(index, value);
    }

    @Override
    protected void _setIntLE(int index, int value) {
        this.setIntLE(index, value);
    }

    @Override
    protected void _setLong(int index, long value) {
        this.setLong(index, value);
    }

    @Override
    public void _setLongLE(int index, long value) {
        this.setLongLE(index, value);
    }

    @Override
    public ArrowBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.udle.getBytes(index + this.offset, dst, dstIndex, length);
        return this;
    }

    @Override
    public ArrowBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.udle.getBytes(index + this.offset, out, length);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.udle.getBytes(index + this.offset, out, length);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.udle.getBytes(index + this.offset, out, position, length);
    }

    @Override
    public ArrowBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.udle.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    public ArrowBuf setBytes(int index, ByteBuffer src, int srcIndex, int length) {
        if (src.isDirect()) {
            this.checkIndex(index, length);
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(src) + (long)srcIndex, this.memoryAddress() + (long)index, length);
        } else if (srcIndex == 0 && src.capacity() == length) {
            this.udle.setBytes(index + this.offset, src);
        } else {
            ByteBuffer newBuf = src.duplicate();
            newBuf.position(srcIndex);
            newBuf.limit(srcIndex + length);
            this.udle.setBytes(index + this.offset, newBuf);
        }
        return this;
    }

    @Override
    public ArrowBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.udle.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    @Override
    public ArrowBuf setBytes(int index, ByteBuffer src) {
        this.udle.setBytes(index + this.offset, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.udle.setBytes(index + this.offset, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.udle.setBytes(index + this.offset, in, length);
    }

    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.udle.setBytes(index + this.offset, in, position, length);
    }

    @Override
    public byte getByte(int index) {
        this.chk(index, 1);
        return PlatformDependent.getByte(this.addr(index));
    }

    @Override
    public void close() {
        this.release();
    }

    public int getPossibleMemoryConsumed() {
        if (this.isEmpty) {
            return 0;
        }
        return this.ledger.getSize();
    }

    public int getActualMemoryConsumed() {
        if (this.isEmpty) {
            return 0;
        }
        return this.ledger.getAccountedSize();
    }

    public String toHexString(int start, int length) {
        int roundedStart = start / 10 * 10;
        StringBuilder sb = new StringBuilder("buffer byte dump\n");
        int index = roundedStart;
        for (int nLogged = 0; nLogged < length; nLogged += 10) {
            sb.append(String.format(" [%05d-%05d]", index, index + 10 - 1));
            for (int i = 0; i < 10; ++i) {
                try {
                    byte b = this.getByte(index++);
                    sb.append(String.format(" 0x%02x", b));
                    continue;
                }
                catch (IndexOutOfBoundsException ioob) {
                    sb.append(" <ioob>");
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String toVerboseString() {
        if (this.isEmpty) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.ledger.print(sb, 0, BaseAllocator.Verbosity.LOG_WITH_STACKTRACE);
        return sb.toString();
    }

    public void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
        BaseAllocator.indent(sb, indent).append(this.toString());
        if (BaseAllocator.DEBUG && !this.isEmpty && verbosity.includeHistoricalLog) {
            sb.append("\n");
            this.historicalLog.buildHistory(sb, indent + 1, verbosity.includeStackTraces);
        }
    }

    @Override
    public ArrowBuf readerIndex(int readerIndex) {
        super.readerIndex(readerIndex);
        return this;
    }

    @Override
    public ArrowBuf writerIndex(int writerIndex) {
        super.writerIndex(writerIndex);
        return this;
    }

    public class TransferResult {
        public final boolean allocationFit;
        public final ArrowBuf buffer;

        private TransferResult(boolean allocationFit, ArrowBuf buffer) {
            this.allocationFit = allocationFit;
            this.buffer = buffer;
        }
    }
}

