/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.CharByteHashMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;

public class CharByteScatterMap
extends CharByteHashMap {
    public CharByteScatterMap() {
        this(4);
    }

    public CharByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharByteScatterMap from(char[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharByteScatterMap map = new CharByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

