/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.DoubleLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.DoubleCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.DoublePredicate;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        int i = 0;
        for (DoubleCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

