/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;

public class VarCharToTextConverter
extends AbstractArrowVectorConverter {
    private VarCharVector varCharVector;

    public VarCharToTextConverter(ValueVector valueVector, DataConversionContext context) {
        super(SnowflakeType.TEXT.name(), valueVector, context);
        this.varCharVector = (VarCharVector)valueVector;
    }

    @Override
    public String toString(int index) {
        byte[] bytes = this.toBytes(index);
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes(int index) {
        return this.isNull(index) ? null : this.varCharVector.get(index);
    }

    @Override
    public Object toObject(int index) {
        return this.toString(index);
    }
}

