/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ArrowResultUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(ArrowResultUtil.class);

    public static Date getDate(int day, TimeZone tz, SFSession session) throws SFException {
        try {
            long milliSecsSinceEpoch = (long)day * 86400000L;
            long milliSecsSinceEpochNew = ArrowResultUtil.moveToTimeZone(milliSecsSinceEpoch, TimeZone.getTimeZone("UTC"), tz);
            Date preDate = new Date(milliSecsSinceEpochNew);
            Date newDate = ResultUtil.adjustDate(preDate);
            Object[] objectArray = new Object[2];
            objectArray[0] = preDate::toString;
            objectArray[1] = newDate::toString;
            logger.debug("Adjust date from {} to {}", objectArray);
            return newDate;
        }
        catch (NumberFormatException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "Invalid date value: " + day), null, null);
        }
    }

    public static long moveToTimeZone(long epoch, TimeZone oldTZ, TimeZone newTZ) {
        if (oldTZ.getRawOffset() == newTZ.getRawOffset()) {
            return epoch;
        }
        int offsetMillisInOldTZ = oldTZ.getOffset(epoch);
        GregorianCalendar calendar = CalendarCache.get(oldTZ);
        calendar.setTimeInMillis(epoch);
        int millisecondWithinDay = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int era = calendar.get(0);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int dayOfMonth = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int offsetMillisInNewTZ = newTZ.getOffset(era, year, month, dayOfMonth, dayOfWeek, millisecondWithinDay);
        int offsetMillis = offsetMillisInOldTZ - offsetMillisInNewTZ;
        return epoch + (long)offsetMillis;
    }
}

