/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.factories;

import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.EncryptionMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeyTypeException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.AESDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.BaseJWEProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.DirectDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.ECDHDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.PasswordBasedDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.RSADecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jca.JWEJCAContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWEDecrypterFactory;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWEDecrypterFactory
implements JWEDecrypterFactory {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final JWEJCAContext jcaContext = new JWEJCAContext();

    static {
        LinkedHashSet algs = new LinkedHashSet();
        algs.addAll(RSADecrypter.SUPPORTED_ALGORITHMS);
        algs.addAll(ECDHDecrypter.SUPPORTED_ALGORITHMS);
        algs.addAll(DirectDecrypter.SUPPORTED_ALGORITHMS);
        algs.addAll(AESDecrypter.SUPPORTED_ALGORITHMS);
        algs.addAll(PasswordBasedDecrypter.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        LinkedHashSet encs = new LinkedHashSet();
        encs.addAll(RSADecrypter.SUPPORTED_ENCRYPTION_METHODS);
        encs.addAll(ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        encs.addAll(DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        encs.addAll(AESDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        encs.addAll(PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(encs);
    }

    @Override
    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return SUPPORTED_ENCRYPTION_METHODS;
    }

    @Override
    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWEDecrypter createJWEDecrypter(JWEHeader header, Key key) throws JOSEException {
        BaseJWEProvider decrypter;
        if (RSADecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && RSADecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof RSAPrivateKey)) {
                throw new KeyTypeException(RSAPrivateKey.class);
            }
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)key;
            decrypter = new RSADecrypter(rsaPrivateKey);
        } else if (ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof ECPrivateKey)) {
                throw new KeyTypeException(ECPrivateKey.class);
            }
            ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
            decrypter = new ECDHDecrypter(ecPrivateKey);
        } else if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey aesKey = (SecretKey)key;
            DirectDecrypter directDecrypter = new DirectDecrypter(aesKey);
            if (!directDecrypter.supportedEncryptionMethods().contains(header.getEncryptionMethod())) {
                throw new KeyLengthException(header.getEncryptionMethod().cekBitLength(), header.getEncryptionMethod());
            }
            decrypter = directDecrypter;
        } else if (AESDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey aesKey = (SecretKey)key;
            AESDecrypter aesDecrypter = new AESDecrypter(aesKey);
            if (!aesDecrypter.supportedJWEAlgorithms().contains(header.getAlgorithm())) {
                throw new KeyLengthException(header.getAlgorithm());
            }
            decrypter = aesDecrypter;
        } else if (PasswordBasedDecrypter.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm()) && PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(header.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            byte[] password = key.getEncoded();
            decrypter = new PasswordBasedDecrypter(password);
        } else {
            throw new JOSEException("Unsupported JWE algorithm or encryption method");
        }
        ((JWEJCAContext)decrypter.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JWEJCAContext)decrypter.getJCAContext()).setProvider(this.jcaContext.getProvider());
        ((JWEJCAContext)decrypter.getJCAContext()).setKeyEncryptionProvider(this.jcaContext.getKeyEncryptionProvider());
        ((JWEJCAContext)decrypter.getJCAContext()).setMACProvider(this.jcaContext.getMACProvider());
        ((JWEJCAContext)decrypter.getJCAContext()).setContentEncryptionProvider(this.jcaContext.getContentEncryptionProvider());
        return decrypter;
    }
}

