/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.LongCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.LongLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.LongCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.LongPredicate;

abstract class AbstractLongCollection
implements LongCollection {
    AbstractLongCollection() {
    }

    @Override
    public int removeAll(final LongLookupContainer c) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final LongLookupContainer c) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final LongPredicate predicate) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public long[] toArray() {
        long[] array = new long[this.size()];
        int i = 0;
        for (LongCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

