/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.AbstractContainerVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.VectorWithOrdinal;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.MapWithOrdinal;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructVector
extends AbstractContainerVector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContainerVector.class);
    private final MapWithOrdinal<String, FieldVector> vectors = new MapWithOrdinal();

    protected AbstractStructVector(String name, BufferAllocator allocator, CallBack callBack) {
        super(name, allocator, callBack);
    }

    @Override
    public void close() {
        for (ValueVector valueVector : this.vectors.values()) {
            valueVector.close();
        }
        this.vectors.clear();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            for (ValueVector valueVector : this.vectors.values()) {
                if (valueVector.allocateNewSafe()) continue;
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return true;
    }

    @Override
    public void reAlloc() {
        for (ValueVector valueVector : this.vectors.values()) {
            valueVector.reAlloc();
        }
    }

    @Override
    public <T extends FieldVector> T addOrGet(String childName, FieldType fieldType, Class<T> clazz) {
        FieldVector existing = this.getChild(childName);
        boolean create = false;
        if (existing == null) {
            create = true;
        } else {
            if (clazz.isAssignableFrom(existing.getClass())) {
                return (T)((FieldVector)clazz.cast(existing));
            }
            if (this.nullFilled(existing)) {
                existing.clear();
                create = true;
            }
        }
        if (create) {
            FieldVector vector = (FieldVector)clazz.cast(fieldType.createNewSingleVector(childName, this.allocator, this.callBack));
            this.putChild(childName, vector);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
            return (T)vector;
        }
        String message = "Arrow does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch";
        throw new IllegalStateException(String.format("Arrow does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch", existing.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    private boolean nullFilled(ValueVector vector) {
        for (int r = 0; r < vector.getValueCount(); ++r) {
            if (vector.isNull(r)) continue;
            return false;
        }
        return true;
    }

    public ValueVector getChildByOrdinal(int id) {
        return this.vectors.getByOrdinal(id);
    }

    @Override
    public <T extends FieldVector> T getChild(String name, Class<T> clazz) {
        ValueVector v = this.vectors.get(name);
        if (v == null) {
            return null;
        }
        return (T)((FieldVector)this.typeify(v, clazz));
    }

    protected ValueVector add(String childName, FieldType fieldType) {
        FieldVector existing = this.getChild(childName);
        if (existing != null) {
            throw new IllegalStateException(String.format("Vector already exists: Existing[%s], Requested[%s] ", existing.getClass().getSimpleName(), fieldType));
        }
        FieldVector vector = fieldType.createNewSingleVector(childName, this.allocator, this.callBack);
        this.putChild(childName, vector);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return vector;
    }

    protected void putChild(String name, FieldVector vector) {
        this.putVector(name, vector);
    }

    protected void putVector(String name, FieldVector vector) {
        ValueVector old = this.vectors.put(Preconditions.checkNotNull(name, "field name cannot be null"), Preconditions.checkNotNull(vector, "vector cannot be null"));
        if (old != null && old != vector) {
            logger.debug("Field [{}] mutated from [{}] to [{}]", new Object[]{name, old.getClass().getSimpleName(), vector.getClass().getSimpleName()});
        }
    }

    protected List<FieldVector> getChildren() {
        int size = this.vectors.size();
        ArrayList<FieldVector> children = new ArrayList<FieldVector>();
        for (int i = 0; i < size; ++i) {
            children.add(this.vectors.getByOrdinal(i));
        }
        return children;
    }

    protected List<String> getChildFieldNames() {
        return this.getChildren().stream().map(child -> child.getField().getName()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.vectors.size();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.unmodifiableCollection(this.vectors.values()).iterator();
    }

    public List<ValueVector> getPrimitiveVectors() {
        ArrayList<ValueVector> primitiveVectors = new ArrayList<ValueVector>();
        for (ValueVector valueVector : this.vectors.values()) {
            if (valueVector instanceof AbstractStructVector) {
                AbstractStructVector structVector = (AbstractStructVector)valueVector;
                primitiveVectors.addAll(structVector.getPrimitiveVectors());
                continue;
            }
            primitiveVectors.add(valueVector);
        }
        return primitiveVectors;
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        int ordinal = this.vectors.getOrdinal(name);
        if (ordinal < 0) {
            return null;
        }
        ValueVector vector = this.vectors.getByOrdinal(ordinal);
        return new VectorWithOrdinal(vector, ordinal);
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (ValueVector valueVector : this.vectors.values()) {
            for (ArrowBuf buf : valueVector.getBuffers(false)) {
                buffers.add(buf);
                if (!clear) continue;
                buf.retain(1);
            }
            if (!clear) continue;
            valueVector.clear();
        }
        return buffers.toArray(new ArrowBuf[buffers.size()]);
    }

    @Override
    public int getBufferSize() {
        int actualBufSize = 0;
        for (ValueVector valueVector : this.vectors.values()) {
            for (ArrowBuf buf : valueVector.getBuffers(false)) {
                actualBufSize += buf.writerIndex();
            }
        }
        return actualBufSize;
    }
}

