/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TinyIntReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class TinyIntVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 1;
    private final FieldReader reader = new TinyIntReaderImpl(this);

    public TinyIntVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TINYINT.getType()), allocator);
    }

    public TinyIntVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 1);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TINYINT;
    }

    public byte get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getByte(index * 1);
    }

    public void get(int index, NullableTinyIntHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getByte(index * 1);
    }

    @Override
    public Byte getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getByte(index * 1);
    }

    public void copyFrom(int fromIndex, int thisIndex, TinyIntVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        byte value = from.valueBuffer.getByte(fromIndex * 1);
        this.valueBuffer.setByte(thisIndex * 1, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TinyIntVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setByte(index * 1, value);
    }

    private void setValue(int index, byte value) {
        this.valueBuffer.setByte(index * 1, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, byte value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableTinyIntHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, TinyIntHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, byte value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableTinyIntHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TinyIntHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, byte value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, byte value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static byte get(ArrowBuf buffer, int index) {
        return buffer.getByte(index * 1);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TinyIntVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        TinyIntVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new TinyIntVector(ref, TinyIntVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(TinyIntVector to) {
            this.to = to;
        }

        @Override
        public TinyIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TinyIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TinyIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TinyIntVector.this);
        }
    }
}

