/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class TinyIntToBooleanConverter
extends AbstractArrowVectorConverter {
    private TinyIntVector tinyIntVector;

    public TinyIntToBooleanConverter(ValueVector fieldVector) {
        super(SnowflakeType.BOOLEAN.name(), fieldVector);
        this.tinyIntVector = (TinyIntVector)fieldVector;
    }

    @Override
    public boolean toBoolean(int index) {
        if (this.tinyIntVector.isNull(index)) {
            return false;
        }
        return this.tinyIntVector.getDataBuffer().getBoolean(index * 1);
    }

    @Override
    public Object toObject(int index) {
        return this.isNull(index) ? null : Boolean.valueOf(this.toBoolean(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : String.valueOf(this.toBoolean(index));
    }
}

