/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class SmallIntToFixedConverter
extends AbstractArrowVectorConverter {
    private SmallIntVector smallIntVector;
    private Integer sfScale;

    public SmallIntToFixedConverter(ValueVector fieldVector) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector);
        this.smallIntVector = (SmallIntVector)fieldVector;
        String scaleStr = fieldVector.getField().getMetadata().get("scale");
        this.sfScale = Integer.parseInt(scaleStr);
    }

    @Override
    public byte toByte(int index) throws SFException {
        short shortVal = this.toShort(index);
        byte byteVal = (byte)shortVal;
        if (byteVal == shortVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", shortVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        if (this.smallIntVector.isNull(index)) {
            return 0;
        }
        if (this.sfScale != 0) {
            short val = this.smallIntVector.getDataBuffer().getShort(index * 2);
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int", val);
        }
        return this.smallIntVector.getDataBuffer().getShort(index * 2);
    }

    @Override
    public int toInt(int index) throws SFException {
        return this.toShort(index);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toShort(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.smallIntVector.isNull(index)) {
            return null;
        }
        short val = this.smallIntVector.getDataBuffer().getShort(index * 2);
        return BigDecimal.valueOf(val, this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : (this.sfScale == 0 ? Short.valueOf(this.toShort(index)) : this.toBigDecimal(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : this.toBigDecimal(index).toString();
    }
}

