/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;

public class IntToDateConverter
extends AbstractArrowVectorConverter {
    private IntVector intVector;
    private SnowflakeDateTimeFormat dateFormatter;

    public IntToDateConverter(ValueVector fieldVector, SnowflakeDateTimeFormat dateFormatter) {
        super(SnowflakeType.DATE.name(), fieldVector);
        this.intVector = (IntVector)fieldVector;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public Date toDate(int index) {
        if (this.intVector.isNull(index)) {
            return null;
        }
        int val = this.intVector.getDataBuffer().getInt(index);
        return new Date(val * 86400000);
    }

    @Override
    public String toString(int index) {
        return this.toDate(index).toString();
    }

    @Override
    public Object toObject(int index) {
        return this.toDate(index);
    }
}

