/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

class SnowflakeStatementV1
implements Statement,
SnowflakeStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeStatementV1.class);
    private static final int NO_UPDATES = -1;
    protected final SnowflakeConnectionV1 connection;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final int resultSetHoldability;
    private int maxRows = 0;
    private final Set<ResultSet> openResultSets = Collections.synchronizedSet(new HashSet());
    private ResultSet resultSet = null;
    private int fetchSize = 50;
    private Boolean isClosed = false;
    private int updateCount = -1;
    private int queryTimeout = 0;
    private final int maxFieldSize = 0x1000000;
    SFStatement sfStatement;
    private boolean poolable;
    private String queryID;
    private List<String> batchQueryIDs = new LinkedList<String>();
    protected final List<BatchEntry> batch = new ArrayList<BatchEntry>();
    private SQLWarning sqlWarnings;

    SnowflakeStatementV1(SnowflakeConnectionV1 connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public SnowflakeStatement(SnowflakeConnectionV1 conn)");
        this.connection = connection;
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet type %d is not supported.", resultSetType), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet concurrency %d is not supported.", resultSetConcurrency), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet holdability %d is not supported.", resultSetHoldability), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.sfStatement = new SFStatement(connection.getSfSession());
    }

    protected void raiseSQLExceptionIfStatementIsClosed() throws SQLException {
        if (this.isClosed.booleanValue()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.executeQueryInternal(sql, null);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, null, true);
    }

    int executeUpdateInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings, boolean updateQueryRequired) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        if (StmtUtil.checkStageManageCommand(sql) != null && parameterBindings != null) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
        }
        try {
            SFBaseResultSet sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE_UPDATE);
            sfResultSet.setSession(this.connection.getSfSession());
            this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            this.queryID = sfResultSet.getQueryId();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        finally {
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = null;
        }
        if (this.updateCount == -1 && updateQueryRequired) {
            throw new SnowflakeSQLException(ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
        }
        return this.updateCount;
    }

    ResultSet executeQueryInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        SFBaseResultSet sfResultSet;
        try {
            sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE_QUERY);
            sfResultSet.setSession(this.connection.getSfSession());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        if (this.resultSet != null) {
            this.openResultSets.add(this.resultSet);
        }
        this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
        return this.getResultSet();
    }

    boolean executeInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        this.connection.injectedDelay();
        logger.debug("execute: {}", () -> SecretDetector.maskSecrets(sql));
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return false;
        }
        try {
            SFBaseResultSet sfResultSet = this.sfStatement.execute(sql, parameterBindings, SFStatement.CallingMethod.EXECUTE);
            sfResultSet.setSession(this.connection.getSfSession());
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
            this.queryID = sfResultSet.getQueryId();
            if (!(sfResultSet.getStatementType().isGenerateResultSet() || this.connection.getSfSession().isSfSQLMode() && !this.sfStatement.hasChildren())) {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
                if (this.resultSet != null) {
                    this.openResultSets.add(this.resultSet);
                }
                this.resultSet = null;
                return false;
            }
            this.updateCount = -1;
            return true;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public String getQueryID() {
        return this.queryID;
    }

    @Override
    public List<String> getBatchQueryIDs() {
        return Collections.unmodifiableList(this.batchQueryIDs);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("public int execute(String sql, int autoGeneratedKeys)");
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("public boolean execute(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.debug("public boolean execute(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        logger.debug("public int[] executeBatch()");
        return this.executeBatchInternal();
    }

    int[] executeBatchInternal() throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        Throwable exceptionReturned = null;
        int[] updateCounts = new int[this.batch.size()];
        this.batchQueryIDs.clear();
        for (int i = 0; i < this.batch.size(); ++i) {
            BatchEntry b = this.batch.get(i);
            try {
                int cnt = this.executeUpdateInternal(b.getSql(), b.getParameterBindings(), false);
                if (cnt == -1) {
                    cnt = -2;
                }
                updateCounts[i] = cnt;
                this.batchQueryIDs.add(this.queryID);
                continue;
            }
            catch (SQLException e) {
                exceptionReturned = exceptionReturned == null ? e : exceptionReturned;
                updateCounts[i] = -3;
            }
        }
        if (exceptionReturned != null) {
            throw new BatchUpdateException(exceptionReturned.getLocalizedMessage(), ((SQLException)exceptionReturned).getSQLState(), ((SQLException)exceptionReturned).getErrorCode(), updateCounts, exceptionReturned);
        }
        return updateCounts;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("public int executeUpdate(String sql, int autoGeneratedKeys)");
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("public int executeUpdate(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.debug("public int executeUpdate(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("public Connection getConnection()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("public int getFetchDirection()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("public int getFetchSize()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        logger.debug("public ResultSet getGeneratedKeys()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return new SnowflakeResultSetV1.EmptyResultSet();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.debug("public int getMaxFieldSize()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return 0x1000000;
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.debug("public int getMaxRows()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.debug("public boolean getMoreResults()");
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        logger.debug("public boolean getMoreResults(int current)");
        this.raiseSQLExceptionIfStatementIsClosed();
        if (this.resultSet != null && (current == 1 || current == 3)) {
            this.resultSet.close();
        }
        boolean hasResultSet = this.sfStatement.getMoreResults(current);
        SFBaseResultSet sfResultSet = this.sfStatement.getResultSet();
        if (hasResultSet) {
            sfResultSet.setSession(this.connection.getSfSession());
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
            this.updateCount = -1;
            return true;
        }
        if (sfResultSet != null) {
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = null;
            try {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            }
            catch (SFException ex) {
                throw new SnowflakeSQLException(ex);
            }
            return false;
        }
        this.updateCount = -1;
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.debug("public int getQueryTimeout()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.debug("public ResultSet getResultSet()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        logger.debug("public int getResultSetConcurrency()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.debug("public int getResultSetHoldability()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.debug("public int getResultSetType()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.debug("public int getUpdateCount()");
        this.raiseSQLExceptionIfStatementIsClosed();
        if (this.updateCount != -1 && this.sfStatement.getResultSet().getStatementType().isDML()) {
            return this.updateCount;
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("public SQLWarning getWarnings()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.sqlWarnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("public boolean isClosed()");
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        logger.debug("public boolean isPoolable()");
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.poolable;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        logger.debug("public void setCursorName(String name)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        logger.debug("public void setEscapeProcessing(boolean enable)");
        this.raiseSQLExceptionIfStatementIsClosed();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("public void setFetchDirection(int direction)");
        this.raiseSQLExceptionIfStatementIsClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("public void setFetchSize(int rows), rows={}", rows);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.debug("public void setMaxFieldSize(int max)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.debug("public void setMaxRows(int max)");
        this.raiseSQLExceptionIfStatementIsClosed();
        this.maxRows = max;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("rows_per_resultset", max);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        logger.debug("public void setPoolable(boolean poolable)");
        this.raiseSQLExceptionIfStatementIsClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
        this.poolable = poolable;
    }

    void setParameter(String name, Object value) throws Exception {
        logger.debug("public void setParameter");
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty(name, value);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.debug("public void setQueryTimeout(int seconds)");
        this.raiseSQLExceptionIfStatementIsClosed();
        this.queryTimeout = seconds;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("query_timeout", seconds);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        logger.debug("public void closeOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        logger.debug("public boolean isCloseOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean removeClosedStatementFromConnection) throws SQLException {
        logger.debug("public void close()");
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
        this.batch.clear();
        Set<ResultSet> set = this.openResultSets;
        synchronized (set) {
            for (ResultSet rs : this.openResultSets) {
                if (rs == null || rs.isClosed()) continue;
                if (rs.isWrapperFor(SnowflakeResultSetV1.class)) {
                    rs.unwrap(SnowflakeResultSetV1.class).close(false);
                    continue;
                }
                rs.close();
            }
            this.openResultSets.clear();
        }
        this.sfStatement.close();
        if (removeClosedStatementFromConnection) {
            this.connection.removeClosedStatement(this);
        }
    }

    @Override
    public void cancel() throws SQLException {
        logger.debug("public void cancel()");
        this.raiseSQLExceptionIfStatementIsClosed();
        try {
            this.sfStatement.cancel();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("public void clearWarnings()");
        this.raiseSQLExceptionIfStatementIsClosed();
        this.sqlWarnings = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.debug("public void addBatch(String sql)");
        this.raiseSQLExceptionIfStatementIsClosed();
        this.batch.add(new BatchEntry(sql, null));
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("public void clearBatch()");
        this.raiseSQLExceptionIfStatementIsClosed();
        this.batch.clear();
    }

    private void executeSetProperty(String sql) {
        logger.debug("setting property");
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("tracing".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3) {
                // empty if block
            }
        } else {
            this.sfStatement.executeSetProperty(sql);
        }
    }

    public SFStatement getSfStatement() {
        return this.sfStatement;
    }

    public void removeClosedResultSet(ResultSet rs) {
        this.openResultSets.remove(rs);
    }

    final class BatchEntry {
        private final String sql;
        private final Map<String, ParameterBindingDTO> parameterBindings;

        BatchEntry(String sql, Map<String, ParameterBindingDTO> parameterBindings) {
            this.sql = sql;
            this.parameterBindings = parameterBindings;
        }

        public String getSql() {
            return this.sql;
        }

        public Map<String, ParameterBindingDTO> getParameterBindings() {
            return this.parameterBindings;
        }
    }
}

