/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.snowflake.client.util.SecretDetector;

public abstract class SnowflakeResultChunk {
    private final String url;
    private final String scrubbedUrl;
    final int colCount;
    int uncompressedSize;
    final int rowCount;
    private long downloadTime;
    private long parseTime;
    private DownloadState downloadState = DownloadState.NOT_STARTED;
    private ReentrantLock lock = new ReentrantLock();
    private Condition downloadCondition = this.lock.newCondition();
    private String downloadError;

    abstract long computeNeededChunkMemory();

    abstract void freeData();

    public SnowflakeResultChunk(String url, int rowCount, int colCount, int uncompressedSize) {
        this.url = url;
        this.scrubbedUrl = SecretDetector.maskSASToken(this.url);
        this.rowCount = rowCount;
        this.colCount = colCount;
        this.uncompressedSize = uncompressedSize;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getScrubbedUrl() {
        return this.scrubbedUrl;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public final int getColCount() {
        return this.colCount;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadTime(long downloadTime) {
        this.downloadTime = downloadTime;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(long parseTime) {
        this.parseTime = parseTime;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Condition getDownloadCondition() {
        return this.downloadCondition;
    }

    public String getDownloadError() {
        return this.downloadError;
    }

    public void setDownloadError(String downloadError) {
        this.downloadError = downloadError;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public void setDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
    }

    public static enum DownloadState {
        NOT_STARTED,
        IN_PROGRESS,
        SUCCESS,
        FAILURE;

    }
}

