/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

public enum SFStatementType {
    UNKNOWN(0L, true),
    PUT(1L, true),
    GET(2L, true),
    LIST(3L, true),
    REMOVE(4L, true),
    SELECT(4096L, true),
    DML(12288L, false),
    INSERT(12544L, false),
    UPDATE(12800L, false),
    DELETE(13056L, false),
    MERGE(13312L, false),
    MULTI_INSERT(13568L, false),
    COPY(13824L, false),
    UNLOAD(14080L, false),
    RECLUSTER(14336L, false),
    SCL(16384L, false),
    ALTER_SESSION(16640L, false),
    USE(17152L, false),
    USE_DATABASE(17153L, false),
    USE_SCHEMA(17154L, false),
    USE_WAREHOUSE(17155L, false),
    SHOW(17408L, true),
    DESCRIBE(17664L, true),
    TCL(20480L, false),
    DDL(24576L, false);

    private final long statementTypeId;
    private final boolean generateResultSet;
    private static final long LEVEL_3_RANGE = 4096L;

    private SFStatementType(long id, boolean generateResultSet) {
        this.statementTypeId = id;
        this.generateResultSet = generateResultSet;
    }

    public static SFStatementType lookUpTypeById(long id) {
        for (SFStatementType type : SFStatementType.values()) {
            if (type.getStatementTypeId() != id) continue;
            return type;
        }
        if (id >= SCL.getStatementTypeId() && id < SCL.getStatementTypeId() + 4096L) {
            return SCL;
        }
        if (id >= TCL.getStatementTypeId() && id < TCL.getStatementTypeId() + 4096L) {
            return TCL;
        }
        if (id >= DDL.getStatementTypeId() && id < DDL.getStatementTypeId() + 4096L) {
            return DDL;
        }
        return UNKNOWN;
    }

    public long getStatementTypeId() {
        return this.statementTypeId;
    }

    public boolean isDDL() {
        return this == DDL;
    }

    public boolean isDML() {
        return this.statementTypeId >= DML.getStatementTypeId() && this.statementTypeId < DML.getStatementTypeId() + 4096L;
    }

    public boolean isTCL() {
        return this == TCL;
    }

    public boolean isSCL() {
        return this == SCL;
    }

    public boolean isGenerateResultSet() {
        return this.generateResultSet;
    }

    public boolean isSelect() {
        return this.statementTypeId == SFStatementType.SELECT.statementTypeId;
    }
}

