/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;

class SnowflakeResultSetV1
extends SnowflakeBaseResultSet
implements SnowflakeResultSet {
    private final SFBaseResultSet sfBaseResultSet;

    SnowflakeResultSetV1(SFBaseResultSet sfBaseResultSet, Statement statement) throws SQLException {
        super(statement);
        this.sfBaseResultSet = sfBaseResultSet;
        try {
            this.resultSetMetaData = new SnowflakeResultSetMetaDataV1(sfBaseResultSet.getMetaData());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.sfBaseResultSet.next();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean removeClosedResultSetFromStatement) throws SQLException {
        this.sfBaseResultSet.close();
        if (removeClosedResultSetFromStatement && this.statement.isWrapperFor(SnowflakeStatementV1.class)) {
            this.statement.unwrap(SnowflakeStatementV1.class).removeClosedResultSet(this);
        }
    }

    @Override
    public String getQueryID() {
        return this.sfBaseResultSet.getQueryId();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.sfBaseResultSet.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getString(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getBoolean(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getByte(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getShort(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getInt(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getLong(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getFloat(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getDouble(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getDate(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getTime(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getTimestamp(columnIndex, tz);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("public ResultSetMetaData getMetaData()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getObject(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getBigDecimal(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getBigDecimal(columnIndex, scale);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        try {
            return this.sfBaseResultSet.getBytes(columnIndex);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        logger.debug("public int getRow()");
        return this.sfBaseResultSet.getRow();
    }

    @Override
    public boolean isFirst() throws SQLException {
        logger.debug("public boolean isFirst()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.sfBaseResultSet.isFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.sfBaseResultSet.isClosed();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.sfBaseResultSet.isLast();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.sfBaseResultSet.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.sfBaseResultSet.isBeforeFirst();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    static class EmptyResultSet
    implements ResultSet {
        private boolean isClosed = false;

        EmptyResultSet() {
        }

        private void raiseSQLExceptionIfResultSetIsClosed() throws SQLException {
            if (this.isClosed()) {
                throw new SnowflakeSQLException(ErrorCode.RESULTSET_ALREADY_CLOSED, new Object[0]);
            }
        }

        @Override
        public boolean wasNull() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean next() throws SQLException {
            return false;
        }

        @Override
        public void close() throws SQLException {
            this.isClosed = true;
        }

        @Override
        public boolean getBoolean(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public long getLong(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0L;
        }

        @Override
        public float getFloat(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0.0f;
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0.0;
        }

        @Override
        public short getShort(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public byte getByte(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return "";
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return new byte[0];
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getAsciiStream(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getUnicodeStream(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public String getString(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public boolean getBoolean(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public byte getByte(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public short getShort(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public int getInt(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public long getLong(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0L;
        }

        @Override
        public float getFloat(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0.0f;
        }

        @Override
        public double getDouble(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0.0;
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public byte[] getBytes(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return new byte[0];
        }

        @Override
        public Date getDate(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Time getTime(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Timestamp getTimestamp(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean isFirst() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean isLast() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public void beforeFirst() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void afterLast() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public boolean first() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean last() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public int getRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public boolean absolute(int row) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean relative(int rows) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean previous() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public int getFetchDirection() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public int getFetchSize() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public int getType() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public int getConcurrency() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean rowInserted() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }

        @Override
        public void updateNull(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBoolean(int columnIndex, boolean x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateByte(int columnIndex, byte x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateShort(int columnIndex, short x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateInt(int columnIndex, int x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateLong(int columnIndex, long x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateFloat(int columnIndex, float x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateDouble(int columnIndex, double x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateString(int columnIndex, String x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBytes(int columnIndex, byte[] x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateDate(int columnIndex, Date x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateTime(int columnIndex, Time x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateObject(int columnIndex, Object x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNull(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBoolean(String columnLabel, boolean x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateByte(String columnLabel, byte x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateShort(String columnLabel, short x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateInt(String columnLabel, int x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateLong(String columnLabel, long x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateFloat(String columnLabel, float x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateDouble(String columnLabel, double x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateString(String columnLabel, String x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBytes(String columnLabel, byte[] x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateDate(String columnLabel, Date x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateTime(String columnLabel, Time x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateObject(String columnLabel, Object x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void insertRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void deleteRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void refreshRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void moveToInsertRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public Statement getStatement() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Ref getRef(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Blob getBlob(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Clob getClob(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Array getArray(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Ref getRef(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Blob getBlob(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Clob getClob(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Array getArray(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Date getDate(int columnIndex, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Date getDate(String columnLabel, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Time getTime(String columnLabel, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public URL getURL(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public URL getURL(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public void updateRef(int columnIndex, Ref x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateRef(String columnLabel, Ref x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(int columnIndex, Blob x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(String columnLabel, Blob x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(int columnIndex, Clob x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(String columnLabel, Clob x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateArray(int columnIndex, Array x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateArray(String columnLabel, Array x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public RowId getRowId(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public RowId getRowId(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public void updateRowId(int columnIndex, RowId x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateRowId(String columnLabel, RowId x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public int getHoldability() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.isClosed;
        }

        @Override
        public void updateNString(int columnIndex, String nString) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNString(String columnLabel, String nString) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public NClob getNClob(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public NClob getNClob(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public SQLXML getSQLXML(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public SQLXML getSQLXML(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public String getNString(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public String getNString(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Reader getNCharacterStream(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Reader getNCharacterStream(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(int columnIndex, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateClob(String columnLabel, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getAsciiStream(String columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getUnicodeStream(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public InputStream getBinaryStream(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
        }

        @Override
        public String getCursorName() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Object getObject(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public int findColumn(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return 0;
        }

        @Override
        public Reader getCharacterStream(int columnIndex) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public Reader getCharacterStream(String columnLabel) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            this.raiseSQLExceptionIfResultSetIsClosed();
            return false;
        }
    }
}

