/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManager;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSSLConnectionSocketFactory;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.http.apache.SdkProxyRoutePlanner;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultRedirectStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLInitializationException;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

public class HttpUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(HttpUtil.class);
    static final int DEFAULT_MAX_CONNECTIONS = 100;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private static CloseableHttpClient httpClient = null;
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig DefaultRequestConfig = null;
    private static boolean socksProxyDisabled = false;
    private static boolean useProxy = false;
    private static String proxyHost;
    private static int proxyPort;
    private static String proxyUser;
    private static String proxyPassword;
    private static String nonProxyHosts;

    static CloseableHttpClient buildHttpClient(OCSPMode ocspMode, File ocspCacheFile, boolean useOcspCacheServer) {
        DefaultRequestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(300000).build();
        TrustManager[] trustManagers = null;
        if (ocspMode != OCSPMode.INSECURE) {
            TrustManager[] tm;
            trustManagers = tm = new TrustManager[]{new SFTrustManager(ocspCacheFile, ocspMode == OCSPMode.FAIL_OPEN, useOcspCacheServer)};
        }
        try {
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", new SFSSLConnectionSocketFactory(trustManagers, socksProxyDisabled)).register("http", (SFSSLConnectionSocketFactory)((Object)new SFConnectionSocketFactory())).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(100);
            if (useProxy) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, credentials);
                SdkProxyRoutePlanner sdkProxyRoutePlanner = new SdkProxyRoutePlanner(proxyHost, proxyPort, nonProxyHosts);
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(DefaultRequestConfig).setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).setUserAgent("-").disableCookieManagement().setProxy(proxy).setDefaultCredentialsProvider(credentialsProvider).setRoutePlanner(sdkProxyRoutePlanner).build();
            } else {
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(DefaultRequestConfig).setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).setUserAgent("-").disableCookieManagement().build();
            }
            return httpClient;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    public static CloseableHttpClient getHttpClient() {
        return HttpUtil.initHttpClient(OCSPMode.FAIL_OPEN, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient initHttpClient(OCSPMode ocspMode, File ocspCacheFile) {
        if (httpClient != null) return httpClient;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpUtil.buildHttpClient(ocspMode, ocspCacheFile, HttpUtil.enableOcspResponseCacheServer());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return httpClient;
        }
    }

    private static boolean enableOcspResponseCacheServer() {
        String flag = null;
        try {
            flag = System.getenv("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED");
        }
        catch (Throwable ex) {
            logger.debug("Failed to get environment variable SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED. Skip");
        }
        if (flag == null) {
            flag = System.getProperty("net.snowflake.jdbc.ocsp_response_cache_server_enabled");
        }
        return !"false".equalsIgnoreCase(flag);
    }

    public static RequestConfig getDefaultRequestConfigWithSocketTimeout(int soTimeoutMs, boolean withoutCookies) {
        HttpUtil.getHttpClient();
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(soTimeoutMs).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getRequestConfigWithoutcookies() {
        HttpUtil.getHttpClient();
        return RequestConfig.copy(DefaultRequestConfig).setCookieSpec("ignoreCookies").build();
    }

    private static String getHttpClientStats() {
        return connectionManager == null ? "" : connectionManager.getTotalStats().toString();
    }

    public static void setSocksProxyDisabled(boolean socksProxyDisabled) {
        HttpUtil.socksProxyDisabled = socksProxyDisabled;
    }

    public static boolean isSocksProxyDisabled() {
        return socksProxyDisabled;
    }

    static String executeRequestWithoutCookies(HttpRequestBase httpRequest, int retryTimeout, int injectSocketTimeout, AtomicBoolean canceling) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, injectSocketTimeout, canceling, true, false, true);
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int injectSocketTimeout, AtomicBoolean canceling) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequest(httpRequest, retryTimeout, injectSocketTimeout, canceling, false);
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int injectSocketTimeout, AtomicBoolean canceling, boolean includeRetryParameters) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, injectSocketTimeout, canceling, false, includeRetryParameters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeRequestInternal(HttpRequestBase httpRequest, int retryTimeout, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid) throws SnowflakeSQLException, IOException {
        String theString;
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        logger.debug("Pool: {} Executing: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        StringWriter writer = null;
        CloseableHttpResponse response = null;
        try {
            response = RestRequest.execute(HttpUtil.getHttpClient(), httpRequest, retryTimeout, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                logger.error("Error executing request: {}", requestInfoScrubbed);
                SnowflakeUtil.logResponseDetails(response, logger);
                if (response != null) {
                    EntityUtils.consume(response.getEntity());
                }
                throw new SnowflakeSQLException("58030", ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response"));
            }
            writer = new StringWriter();
            try (InputStream ins = response.getEntity().getContent();){
                IOUtils.copy(ins, writer, "UTF-8");
            }
            theString = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        IOUtils.closeQuietly(response);
        logger.debug("Pool: {} Request returned for: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        return theString;
    }

    public static void configureCustomProxyProperties(Map<SFSessionProperty, Object> connectionPropertiesMap) {
        if (connectionPropertiesMap.containsKey((Object)SFSessionProperty.USE_PROXY)) {
            useProxy = (Boolean)connectionPropertiesMap.get((Object)SFSessionProperty.USE_PROXY);
        }
        if (useProxy) {
            proxyHost = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST);
            proxyPort = Integer.parseInt(connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PORT).toString());
            proxyUser = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_USER);
            proxyPassword = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PASSWORD);
            nonProxyHosts = (String)connectionPropertiesMap.get((Object)SFSessionProperty.NON_PROXY_HOSTS);
        }
    }

    private static final class SFConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        private SFConnectionSocketFactory() {
        }

        @Override
        public Socket createSocket(HttpContext ctx) throws IOException {
            if (socksProxyDisabled) {
                return new Socket(Proxy.NO_PROXY);
            }
            return super.createSocket(ctx);
        }
    }

    public static final class HttpInputStream
    extends InputStream {
        private final InputStream httpIn;

        public HttpInputStream(InputStream httpIn) {
            this.httpIn = httpIn;
        }

        @Override
        public final int available() throws IOException {
            int available = this.httpIn.available();
            return available == 0 ? 1 : available;
        }

        @Override
        public final int read() throws IOException {
            return this.httpIn.read();
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.httpIn.read(b);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return this.httpIn.read(b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            return this.httpIn.skip(n);
        }

        @Override
        public final void close() throws IOException {
            this.httpIn.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.httpIn.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.httpIn.reset();
        }

        @Override
        public final boolean markSupported() {
            return this.httpIn.markSupported();
        }
    }
}

