/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.snowflake.client.jdbc.internal.org.jsoup.Jsoup;
import net.snowflake.client.jdbc.internal.org.jsoup.helper.Validate;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.CDataNode;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Comment;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Document;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.DocumentType;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Element;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.LeafNode;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Node;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.TextNode;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.XmlDeclaration;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.ParseErrorList;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.ParseSettings;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.Parser;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.Tag;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.Token;
import net.snowflake.client.jdbc.internal.org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    Document parse(Reader input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking(), ParseSettings.preserveCase);
    }

    Document parse(String input, String baseUri) {
        return this.parse(new StringReader(input), baseUri, ParseErrorList.noTracking(), ParseSettings.preserveCase);
    }

    @Override
    protected void initialiseParse(Reader input, String baseUri, ParseErrorList errors, ParseSettings settings) {
        super.initialiseParse(input, baseUri, errors, settings);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name(), this.settings);
        Element el = new Element(tag, this.baseUri, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        Document doc;
        String data;
        Comment comment = new Comment(commentToken.getData());
        LeafNode insert = comment;
        if (commentToken.bogus && (data = comment.getData()).length() > 1 && (data.startsWith("!") || data.startsWith("?")) && (doc = Jsoup.parse("<" + data.substring(1, data.length() - 1) + ">", this.baseUri, Parser.xmlParser())).childNodeSize() > 0) {
            Element el = doc.child(0);
            insert = new XmlDeclaration(this.settings.normalizeTag(el.tagName()), data.startsWith("!"));
            ((Node)insert).attributes().addAll(el.attributes());
        }
        this.insertNode(insert);
    }

    void insert(Token.Character token) {
        String data = token.getData();
        this.insertNode(token.isCData() ? new CDataNode(data) : new TextNode(data));
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(d.getName()), d.getPublicIdentifier(), d.getSystemIdentifier());
        doctypeNode.setPubSysKey(d.getPubSysKey());
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element next;
        int pos;
        String elName = this.settings.normalizeTag(endTag.tagName);
        Element firstFound = null;
        for (pos = this.stack.size() - 1; pos >= 0; --pos) {
            next = (Element)this.stack.get(pos);
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0; --pos) {
            next = (Element)this.stack.get(pos);
            this.stack.remove(pos);
            if (next == firstFound) break;
        }
    }

    List<Node> parseFragment(String inputFragment, String baseUri, ParseErrorList errors, ParseSettings settings) {
        this.initialiseParse(new StringReader(inputFragment), baseUri, errors, settings);
        this.runParser();
        return this.doc.childNodes();
    }
}

