/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFResultSet
extends SFBaseResultSet {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFResultSet.class);
    private int columnCount = 0;
    private int currentChunkRowCount = 0;
    private int currentChunkRowIndex = -1;
    private JsonNode firstChunkRowset = null;
    private SnowflakeResultChunk currentChunk = null;
    private String queryId;
    private SFStatementType statementType;
    private boolean totalRowCountTruncated;
    private boolean sortResult = false;
    private Object[][] firstChunkSortedRowSet;
    private final long firstChunkTime;
    private long chunkCount = 0L;
    private long nextChunkIndex = 0L;
    private SnowflakeChunkDownloader chunkDownloader;
    protected SFStatement statement;
    private final boolean arrayBindSupported;
    private Telemetry telemetryClient;

    public SFResultSet(JsonNode result, SFStatement statement, boolean sortResult) throws SQLException, SFException {
        this.statement = statement;
        this.columnCount = 0;
        this.sortResult = sortResult;
        this.firstChunkTime = System.currentTimeMillis();
        SFSession session = this.statement.getSession();
        this.telemetryClient = session.getTelemetryClient();
        ResultUtil.ResultInput resultInput = new ResultUtil.ResultInput();
        resultInput.setResultJSON(result).setConnectionTimeout(session.getHttpClientConnectionTimeout()).setSocketTimeout(session.getHttpClientSocketTimeout()).setNetworkTimeoutInMilli(session.getNetworkTimeoutInMilli());
        ResultUtil.ResultOutput resultOutput = ResultUtil.processResult(resultInput, statement.getSession());
        this.queryId = resultOutput.getQueryId();
        this.statementType = resultOutput.getStatementType();
        this.totalRowCountTruncated = resultOutput.isTotalRowCountTruncated();
        this.parameters = resultOutput.getParameters();
        this.columnCount = resultOutput.getColumnCount();
        this.firstChunkRowset = resultOutput.getAndClearCurrentChunkRowset();
        this.currentChunkRowCount = resultOutput.getCurrentChunkRowCount();
        this.chunkCount = resultOutput.getChunkCount();
        this.chunkDownloader = resultOutput.getChunkDownloader();
        this.timestampNTZFormatter = resultOutput.getTimestampNTZFormatter();
        this.timestampLTZFormatter = resultOutput.getTimestampLTZFormatter();
        this.timestampTZFormatter = resultOutput.getTimestampTZFormatter();
        this.dateFormatter = resultOutput.getDateFormatter();
        this.timeFormatter = resultOutput.getTimeFormatter();
        this.timeZone = resultOutput.getTimeZone();
        this.honorClientTZForTimestampNTZ = resultOutput.isHonorClientTZForTimestampNTZ();
        this.binaryFormatter = resultOutput.getBinaryFormatter();
        this.resultVersion = resultOutput.getResultVersion();
        this.numberOfBinds = resultOutput.getNumberOfBinds();
        this.arrayBindSupported = resultOutput.isArrayBindSupported();
        session.setDatabase(resultOutput.getFinalDatabaseName());
        session.setSchema(resultOutput.getFinalSchemaName());
        session.setRole(resultOutput.getFinalRoleName());
        session.setWarehouse(resultOutput.getFinalWarehouseName());
        SessionUtil.updateSfDriverParamValues(this.parameters, statement.getSession());
        if (sortResult) {
            if (this.chunkCount > 0L) {
                throw new SnowflakeSQLException("0A000", ErrorCode.CLIENT_SIDE_SORTING_NOT_SUPPORTED.getMessageCode());
            }
            this.sortResultSet();
        }
        if (resultOutput.getSendResultTime() != 0L) {
            long timeConsumeFirstResult = this.firstChunkTime - resultOutput.getSendResultTime();
            this.logMetric(TelemetryField.TIME_CONSUME_FIRST_RESULT, timeConsumeFirstResult);
        }
        StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, 0));
        this.resultSetMetaData = new SFResultSetMetaData(resultOutput.getResultColumnMetadata(), this.queryId, session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
    }

    private boolean fetchNextRow() throws SFException, SnowflakeSQLException {
        if (this.sortResult) {
            return this.fetchNextRowSorted();
        }
        return this.fetchNextRowUnsorted();
    }

    private boolean fetchNextRowSorted() {
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            return true;
        }
        this.firstChunkSortedRowSet = null;
        return false;
    }

    private boolean fetchNextRowUnsorted() throws SFException, SnowflakeSQLException {
        logger.debug("Entering fetchJSONNextRow");
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            return true;
        }
        this.firstChunkRowset = null;
        if (this.nextChunkIndex < this.chunkCount) {
            try {
                StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, this.nextChunkIndex));
                SnowflakeResultChunk nextChunk = this.chunkDownloader.getNextChunkToConsume();
                if (nextChunk == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Expect chunk but got null for chunk index " + this.nextChunkIndex);
                }
                this.currentChunkRowIndex = 0;
                this.currentChunkRowCount = nextChunk.getRowCount();
                this.currentChunk = nextChunk;
                logger.debug("Moving to chunk index {}, row count={}", this.nextChunkIndex, this.currentChunkRowCount);
                ++this.nextChunkIndex;
                return true;
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
        }
        if (this.chunkCount > 0L) {
            logger.debug("End of chunks");
            SnowflakeChunkDownloader.Metrics metrics = this.chunkDownloader.terminate();
            this.logChunkDownloaderMetrics(metrics);
        }
        return false;
    }

    private void logMetric(TelemetryField field, long value) {
        TelemetryData data = TelemetryUtil.buildJobData(this.queryId, field, value);
        this.telemetryClient.tryAddLogToBatch(data);
    }

    private void logChunkDownloaderMetrics(SnowflakeChunkDownloader.Metrics metrics) {
        if (metrics != null) {
            this.logMetric(TelemetryField.TIME_WAITING_FOR_CHUNKS, metrics.millisWaiting);
            this.logMetric(TelemetryField.TIME_DOWNLOADING_CHUNKS, metrics.millisDownloading);
            this.logMetric(TelemetryField.TIME_PARSING_CHUNKS, metrics.millisParsing);
        }
    }

    @Override
    public boolean next() throws SFException, SnowflakeSQLException {
        if (this.isClosed()) {
            return false;
        }
        if (this.fetchNextRow()) {
            ++this.row;
            if (this.isLast()) {
                long timeConsumeLastResult = System.currentTimeMillis() - this.firstChunkTime;
                this.logMetric(TelemetryField.TIME_CONSUME_LAST_RESULT, timeConsumeLastResult);
            }
            return true;
        }
        logger.debug("end of result");
        if (this.totalRowCountTruncated || System.getProperty("snowflake.enable_incident_test2") != null && System.getProperty("snowflake.enable_incident_test2").equals("true")) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.MAX_RESULT_LIMIT_EXCEEDED, new Object[0]), this.queryId, null);
        }
        return false;
    }

    @Override
    protected Object getObjectInternal(int columnIndex) throws SFException {
        Object retValue;
        logger.debug("getObjectInternal: {}", columnIndex);
        if (columnIndex <= 0 || columnIndex > this.resultSetMetaData.getColumnCount()) {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        int internalColumnIndex = columnIndex - 1;
        if (this.sortResult) {
            retValue = this.firstChunkSortedRowSet[this.currentChunkRowIndex][internalColumnIndex];
        } else if (this.firstChunkRowset != null) {
            retValue = SnowflakeResultChunk.extractCell(this.firstChunkRowset, this.currentChunkRowIndex, internalColumnIndex);
        } else if (this.currentChunk != null) {
            retValue = this.currentChunk.getCell(this.currentChunkRowIndex, internalColumnIndex);
        } else {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        this.wasNull = retValue == null;
        return retValue;
    }

    private void sortResultSet() {
        this.firstChunkSortedRowSet = new Object[this.currentChunkRowCount][];
        for (int rowIdx = 0; rowIdx < this.currentChunkRowCount; ++rowIdx) {
            this.firstChunkSortedRowSet[rowIdx] = new Object[this.columnCount];
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                this.firstChunkSortedRowSet[rowIdx][colIdx] = SnowflakeResultChunk.extractCell(this.firstChunkRowset, rowIdx, colIdx);
            }
        }
        Arrays.sort(this.firstChunkSortedRowSet, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] a, Object[] b) {
                int numCols = a.length;
                for (int colIdx = 0; colIdx < numCols; ++colIdx) {
                    if (a[colIdx] == null && b[colIdx] == null) continue;
                    if (a[colIdx] == null) {
                        return 1;
                    }
                    if (b[colIdx] == null) {
                        return -1;
                    }
                    int res = a[colIdx].toString().compareTo(b[colIdx].toString());
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        });
    }

    @Override
    public boolean isLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkRowIndex + 1 == this.currentChunkRowCount;
    }

    @Override
    public boolean isAfterLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkRowIndex >= this.currentChunkRowCount;
    }

    @Override
    public void close() {
        super.close();
        if (this.chunkDownloader != null) {
            this.chunkDownloader.releaseAllChunkMemoryUsage();
            SnowflakeChunkDownloader.Metrics metrics = this.chunkDownloader.terminate();
            this.logChunkDownloaderMetrics(metrics);
            this.firstChunkSortedRowSet = null;
            this.firstChunkRowset = null;
            this.currentChunk = null;
        }
    }

    @Override
    public SFStatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setStatementType(SFStatementType statementType) {
        this.statementType = statementType;
    }

    @Override
    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }
}

