/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeClob;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

abstract class SnowflakeBaseResultSet
implements ResultSet {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeBaseResultSet.class);
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    protected final Statement statement;
    protected SnowflakeResultSetMetaData resultSetMetaData = null;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    private int fetchSize = 0;

    SnowflakeBaseResultSet(Statement statement) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.resultSetConcurrency = statement.getResultSetConcurrency();
        this.resultSetHoldability = statement.getResultSetHoldability();
    }

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean isClosed() throws SQLException;

    protected void raiseSQLExceptionIfResultSetIsClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.RESULTSET_ALREADY_CLOSED, new Object[0]);
        }
    }

    @Override
    public abstract byte[] getBytes(int var1) throws SQLException;

    public abstract Date getDate(int var1, TimeZone var2) throws SQLException;

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    @Override
    public abstract Time getTime(int var1) throws SQLException;

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }

    public abstract Timestamp getTimestamp(int var1, TimeZone var2) throws SQLException;

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getAsciiStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getUnicodeStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        logger.debug("public InputStream getBinaryStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        logger.debug("public String getString(String columnLabel)");
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        logger.debug("public boolean getBoolean(String columnLabel)");
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        logger.debug("public byte getByte(String columnLabel)");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        logger.debug("public short getShort(String columnLabel)");
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        logger.debug("public int getInt(String columnLabel)");
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        logger.debug("public long getLong(String columnLabel)");
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        logger.debug("public float getFloat(String columnLabel)");
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        logger.debug("public double getDouble(String columnLabel)");
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(String columnLabel, int scale)");
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        logger.debug("public byte[] getBytes(String columnLabel)");
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        logger.debug("public Date getDate(String columnLabel)");
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        logger.debug("public Time getTime(String columnLabel)");
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        logger.debug("public Timestamp getTimestamp(String columnLabel)");
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getAsciiStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getUnicodeStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        logger.debug("public InputStream getBinaryStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("public SQLWarning getWarnings()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("public void clearWarnings()");
        this.raiseSQLExceptionIfResultSetIsClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        logger.debug("public String getCursorName()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        logger.debug("public ResultSetMetaData getMetaData()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        logger.debug("public Object getObject(String columnLabel)");
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        logger.debug("public int findColumn(String columnLabel)");
        this.raiseSQLExceptionIfResultSetIsClosed();
        int columnIndex = this.resultSetMetaData.getColumnIndex(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("Column not found: " + columnLabel);
        }
        return ++columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        logger.debug("public Reader getCharacterStream(int columnIndex)");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return new StringReader(this.getString(columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        logger.debug("public Reader getCharacterStream(String columnLabel)");
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        logger.debug("public BigDecimal getBigDecimal(String columnLabel)");
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public void beforeFirst() throws SQLException {
        logger.debug("public void beforeFirst()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        logger.debug("public void afterLast()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        logger.debug("public boolean first()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        logger.debug("public boolean last()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        logger.debug("public boolean absolute(int row)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        logger.debug("public boolean relative(int rows)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        logger.debug("public boolean previous()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("public int getFetchDirection()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("public void setFetchDirection(int direction)");
        this.raiseSQLExceptionIfResultSetIsClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("public int getFetchSize()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("public void setFetchSize(int rows)");
        this.raiseSQLExceptionIfResultSetIsClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        logger.debug("public int getType()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        logger.debug("public int getConcurrency()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        logger.debug("public boolean rowUpdated()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        logger.debug("public boolean rowInserted()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        logger.debug("public boolean rowDeleted()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        logger.debug("public void updateNull(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        logger.debug("public void updateBoolean(int columnIndex, boolean x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        logger.debug("public void updateByte(int columnIndex, byte x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        logger.debug("public void updateShort(int columnIndex, short x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        logger.debug("public void updateInt(int columnIndex, int x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        logger.debug("public void updateLong(int columnIndex, long x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        logger.debug("public void updateFloat(int columnIndex, float x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        logger.debug("public void updateDouble(int columnIndex, double x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        logger.debug("public void updateBigDecimal(int columnIndex, BigDecimal x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        logger.debug("public void updateString(int columnIndex, String x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        logger.debug("public void updateBytes(int columnIndex, byte[] x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        logger.debug("public void updateDate(int columnIndex, Date x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        logger.debug("public void updateTime(int columnIndex, Time x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        logger.debug("public void updateTimestamp(int columnIndex, Timestamp x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        logger.debug("public void updateObject(int columnIndex, Object x, int scaleOrLength)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        logger.debug("public void updateObject(int columnIndex, Object x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        logger.debug("public void updateNull(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        logger.debug("public void updateBoolean(String columnLabel, boolean x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        logger.debug("public void updateByte(String columnLabel, byte x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        logger.debug("public void updateShort(String columnLabel, short x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        logger.debug("public void updateInt(String columnLabel, int x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        logger.debug("public void updateLong(String columnLabel, long x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        logger.debug("public void updateFloat(String columnLabel, float x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        logger.debug("public void updateDouble(String columnLabel, double x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        logger.debug("public void updateBigDecimal(String columnLabel, BigDecimal x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        logger.debug("public void updateString(String columnLabel, String x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        logger.debug("public void updateBytes(String columnLabel, byte[] x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        logger.debug("public void updateDate(String columnLabel, Date x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        logger.debug("public void updateTime(String columnLabel, Time x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        logger.debug("public void updateTimestamp(String columnLabel, Timestamp x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x, int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader,int length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        logger.debug("public void updateObject(String columnLabel, Object x, int scaleOrLength)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        logger.debug("public void updateObject(String columnLabel, Object x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        logger.debug("public void insertRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        logger.debug("public void updateRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        logger.debug("public void deleteRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        logger.debug("public void refreshRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        logger.debug("public void cancelRowUpdates()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        logger.debug("public void moveToInsertRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        logger.debug("public void moveToCurrentRow()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        logger.debug("public Statement getStatement()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        logger.debug("public Object getObject(int columnIndex, Map<String, Class<?>> map)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        logger.debug("public Ref getRef(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        logger.debug("public Blob getBlob(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        logger.debug("public Clob getClob(int columnIndex)");
        return new SnowflakeClob(this.getString(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        logger.debug("public Array getArray(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        logger.debug("public Object getObject(String columnLabel, Map<String, Class<?>> map)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        logger.debug("public Ref getRef(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        logger.debug("public Blob getBlob(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        logger.debug("public Clob getClob(String columnLabel)");
        return new SnowflakeClob(this.getString(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        logger.debug("public Array getArray(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Date getDate(int columnIndex, Calendar cal)");
        return this.getDate(columnIndex, cal.getTimeZone());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Date getDate(String columnLabel, Calendar cal)");
        return this.getDate(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Time getTime(int columnIndex, Calendar cal)");
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Time getTime(String columnLabel, Calendar cal)");
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        logger.debug("public Timestamp getTimestamp(int columnIndex, Calendar cal)");
        return this.getTimestamp(columnIndex, cal.getTimeZone());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        logger.debug("public Timestamp getTimestamp(String columnLabel, Calendar cal)");
        return this.getTimestamp(this.findColumn(columnLabel), cal.getTimeZone());
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        logger.debug("public URL getURL(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        logger.debug("public URL getURL(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        logger.debug("public void updateRef(int columnIndex, Ref x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        logger.debug("public void updateRef(String columnLabel, Ref x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, Blob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, Blob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Clob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Clob x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        logger.debug("public void updateArray(int columnIndex, Array x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        logger.debug("public void updateArray(String columnLabel, Array x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        logger.debug("public RowId getRowId(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        logger.debug("public RowId getRowId(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        logger.debug("public void updateRowId(int columnIndex, RowId x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        logger.debug("public void updateRowId(String columnLabel, RowId x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.debug("public int getHoldability()");
        this.raiseSQLExceptionIfResultSetIsClosed();
        return this.resultSetHoldability;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        logger.debug("public void updateNString(int columnIndex, String nString)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        logger.debug("public void updateNString(String columnLabel, String nString)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, NClob nClob)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, NClob nClob)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        logger.debug("public NClob getNClob(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        logger.debug("public NClob getNClob(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        logger.debug("public SQLXML getSQLXML(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        logger.debug("public SQLXML getSQLXML(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        logger.debug("public void updateSQLXML(int columnIndex, SQLXML xmlObject)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        logger.debug("public void updateSQLXML(String columnLabel, SQLXML xmlObject)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        logger.debug("public String getNString(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        logger.debug("public String getNString(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        logger.debug("public Reader getNCharacterStream(int columnIndex)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        logger.debug("public Reader getNCharacterStream(String columnLabel)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.debug("public void updateNCharacterStream(int columnIndex, Reader x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNCharacterStream(String columnLabel, Reader reader,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, InputStream inputStream, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, InputStream inputStream,long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, Reader reader, long length)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.debug("public void updateNCharacterStream(int columnIndex, Reader x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateNCharacterStream(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        logger.debug("public void updateAsciiStream(int columnIndex, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        logger.debug("public void updateBinaryStream(int columnIndex, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.debug("public void updateCharacterStream(int columnIndex, Reader x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        logger.debug("public void updateAsciiStream(String columnLabel, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        logger.debug("public void updateBinaryStream(String columnLabel, InputStream x)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateCharacterStream(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        logger.debug("public void updateBlob(int columnIndex, InputStream inputStream)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        logger.debug("public void updateBlob(String columnLabel, InputStream inputStream)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        logger.debug("public void updateClob(int columnIndex, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateClob(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        logger.debug("public void updateNClob(int columnIndex, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        logger.debug("public void updateNClob(String columnLabel, Reader reader)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        logger.debug("public <T> T getObject(int columnIndex,Class<T> type)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        logger.debug("public <T> T getObject(String columnLabel,Class<T> type)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        throw new SQLFeatureNotSupportedException();
    }
}

