/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.Incident;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonEncoding;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ISO8601DateFormat;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.JodaModule;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.joda.time.DateTime;
import net.snowflake.client.jdbc.internal.yammer.metrics.Metrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.Clock;
import net.snowflake.client.jdbc.internal.yammer.metrics.core.VirtualMachineMetrics;
import net.snowflake.client.jdbc.internal.yammer.metrics.reporting.MetricsServlet;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class IncidentUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(IncidentUtil.class);
    private static final int STACK_TRACE_SIZE = 10;
    public static final String CLIENT_TYPE = "clientType";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String CLIENT_BUILD_ID = "clientBuildId";
    public static final String INCIDENT_ID = "incidentId";
    public static final String STACKTRACE = "stackTrace";
    public static final String REQUEST_ID = "requestId";
    public static final String JOB_ID = "jobId";
    public static final String SIGNATURE = "signature";
    public static final String REPORTER = "reporter";
    public static final String DETAIL = "detail";
    public static final String INCIDENT_TYPE = "incidentType";
    public static final String TIMESTAMP = "timestamp";
    public static final String INCIDENT_REPORT = "incidentReport";
    public static final String CLIENT_INFO = "clientInfo";
    public static final String INCIDENT_INFO = "incidentInfo";
    public static final String THROTTLE_SIGNATURE = "throttleSignature";
    public static final String INC_DUMP_FILE_NAME = "sf_incident_";
    public static final String INC_DUMP_FILE_EXT = ".dmp.gz";

    public static SFException generateIncidentWithSignatureAndException(SFSession session, String requestId, String jobUuid, String signature, ErrorCode errorCode, Object ... params) {
        return IncidentUtil.generateIncidentWithSignatureAndException(session != null ? session.getSessionToken() : null, session != null ? session.getServerUrl() : null, requestId, jobUuid, signature, errorCode, params);
    }

    public static SFException generateIncidentWithSignatureAndException(String sessionToken, String serverUrl, String requestId, String jobUuid, String signature, ErrorCode errorCode, Object ... params) {
        SFException sfe = new SFException(errorCode, params);
        StackTraceElement[] stack = sfe.getStackTrace();
        String caller = null;
        for (int i = 1; i < stack.length; ++i) {
            if (stack[i].getMethodName().equals("generateIncidentWithException")) continue;
            caller = String.valueOf(stack[i]);
            break;
        }
        String causeStr = sfe.toString() + " at " + caller;
        if (sessionToken != null && serverUrl != null) {
            Map<String, Object> incidentInfo = IncidentUtil.buildIncidentReport(sessionToken, serverUrl, signature, null, requestId, jobUuid, causeStr);
            EventUtil.triggerIncident(incidentInfo);
        } else {
            logger.debug("Failed to generate incident, sessionToken valid={} serverUrl={}", sessionToken != null, serverUrl);
        }
        return sfe;
    }

    public static SFException generateIncidentWithException(SFSession session, String requestId, String jobUuid, ErrorCode errorCode, Object ... params) {
        return IncidentUtil.generateIncidentWithException(session != null ? session.getSessionToken() : null, session != null ? session.getServerUrl() : null, requestId, jobUuid, errorCode, params);
    }

    public static SFException generateIncidentWithException(SFSession session, String requestId, String jobUuid, Throwable cause, ErrorCode errorCode, Object ... params) {
        return IncidentUtil.generateIncidentWithException(session != null ? session.getSessionToken() : null, session != null ? session.getServerUrl() : null, requestId, jobUuid, cause, errorCode, params);
    }

    public static SFException generateIncidentWithException(String sessionToken, String serverUrl, String requestId, String jobUuid, Throwable cause, ErrorCode errorCode, Object ... params) {
        String causeStr = null;
        if (cause != null) {
            StackTraceElement[] stack = cause.getStackTrace();
            String topOfStack = null;
            if (stack.length > 0) {
                topOfStack = String.valueOf(stack[0]);
            }
            causeStr = cause.toString() + " at " + topOfStack;
        } else {
            logger.debug("Attempting to generate incident and SFException with null cause");
        }
        SFException sfe = new SFException(cause, errorCode, params);
        if (sessionToken != null && serverUrl != null) {
            Map<String, Object> incidentInfo = IncidentUtil.buildIncidentReport(sessionToken, serverUrl, causeStr, null, requestId, jobUuid, causeStr);
            EventUtil.triggerIncident(incidentInfo);
        } else {
            logger.debug("Failed to generate incident, sessionToken valid={} serverUrl={}", sessionToken != null, serverUrl);
        }
        return sfe;
    }

    public static SFException generateIncidentWithException(String sessionToken, String serverUrl, String requestId, String jobUuid, ErrorCode errorCode, Object ... params) {
        SFException sfe = new SFException(errorCode, params);
        StackTraceElement[] stack = sfe.getStackTrace();
        String caller = null;
        for (int i = 1; i < stack.length; ++i) {
            if (stack[i].getMethodName().equals("generateIncidentWithException")) continue;
            caller = String.valueOf(stack[i]);
            break;
        }
        String causeStr = sfe.toString() + " at " + caller;
        if (sessionToken != null && serverUrl != null) {
            Map<String, Object> incidentInfo = IncidentUtil.buildIncidentReport(sessionToken, serverUrl, causeStr, null, requestId, jobUuid, causeStr);
            EventUtil.triggerIncident(incidentInfo);
        } else {
            logger.debug("Failed to generate incident, sessionToken valid={} serverUrl={}", sessionToken != null, serverUrl);
        }
        return sfe;
    }

    public static void generateIncident(SFSession session, String signature, String detail, String requestId, String jobUuid, Throwable cause) {
        if (session != null) {
            IncidentUtil.generateIncident(session.getSessionToken(), session.getServerUrl(), signature, detail, requestId, jobUuid, cause);
        }
    }

    public static void generateIncident(String sessionToken, String serverUrl, String signature, String detail, String requestId, String jobUuid, Throwable cause) {
        String causeStr = null;
        if (cause != null) {
            StackTraceElement[] stack = cause.getStackTrace();
            String topOfStack = null;
            if (stack.length > 0) {
                topOfStack = String.valueOf(stack[0]);
            }
            causeStr = cause.toString() + " at " + topOfStack;
        } else {
            logger.debug("Attempting to generate incident without cause, signature={}, detail={}", signature, detail);
        }
        if (sessionToken != null && serverUrl != null) {
            Map<String, Object> incidentInfo = IncidentUtil.buildIncidentReport(sessionToken, serverUrl, signature, detail, requestId, jobUuid, causeStr);
            EventUtil.triggerIncident(incidentInfo);
        } else {
            logger.debug("Failed to generate incident, sessionToken valid={} serverUrl={}", sessionToken != null, serverUrl);
        }
    }

    private static Map<String, Object> buildIncidentReport(String sessionToken, String serverUrl, String signature, String detail, String requestId, String jobUuid, String cause) {
        Preconditions.checkArgument(sessionToken != null && serverUrl != null);
        HashMap<String, Object> incident = new HashMap<String, Object>();
        HashMap<String, Object> incidentInfo = new HashMap<String, Object>();
        HashMap<String, Object> incidentReport = new HashMap<String, Object>();
        incidentReport.put(CLIENT_TYPE, "JDBC");
        incidentReport.put(CLIENT_VERSION, SnowflakeDriver.implementVersion);
        incidentReport.put(INCIDENT_ID, Incident.generateIncidentId());
        int topOfStack = 2;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        while (stes[topOfStack].getMethodName().startsWith("generateIncident")) {
            ++topOfStack;
        }
        StackTraceElement caller = stes[topOfStack];
        String reporter = caller.getClassName() + ":" + caller.getMethodName() + ":" + caller.getLineNumber();
        String detailMessage = detail == null && cause == null ? null : (detail == null ? "" : detail + " : ") + (cause == null ? "" : cause);
        StackTraceElement[] strace = new StackTraceElement[10];
        for (int i = 0; i < 10 && i + topOfStack < stes.length; ++i) {
            strace[i] = stes[i + topOfStack];
        }
        incidentReport.put(STACKTRACE, strace);
        incidentReport.put(REQUEST_ID, requestId);
        incidentReport.put(JOB_ID, jobUuid);
        incidentReport.put(INCIDENT_TYPE, Event.EventType.INCIDENT.getDescription());
        incidentInfo.put(SIGNATURE, signature);
        incidentInfo.put(REPORTER, reporter);
        incidentInfo.put(DETAIL, detailMessage);
        incidentInfo.put(TIMESTAMP, DateTime.now().toString());
        incidentInfo.put(INCIDENT_REPORT, incidentReport);
        incident.put(SFSessionProperty.SERVER_URL.getPropertyKey(), serverUrl);
        incident.put("Token", sessionToken);
        incident.put(INCIDENT_INFO, incidentInfo);
        incident.put(THROTTLE_SIGNATURE, signature);
        return incident;
    }

    public static String oneLiner(Throwable thrown) {
        StackTraceElement[] stack = thrown.getStackTrace();
        String topOfStack = null;
        if (stack.length > 0) {
            topOfStack = String.valueOf(stack[0]);
        }
        return thrown.toString() + " at " + topOfStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpVmMetrics(String incidentId) {
        try (PrintWriter writer = null;){
            String dumpFile = EventUtil.getDumpPathPrefix() + "/" + INC_DUMP_FILE_NAME + incidentId + INC_DUMP_FILE_EXT;
            GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(dumpFile));
            writer = new PrintWriter(outStream, true);
            VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();
            writer.print("\n\n\n---------------------------  METRICS ---------------------------\n\n");
            writer.flush();
            JsonFactory jf = new JsonFactory();
            jf.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            ObjectMapper mapper = new ObjectMapper(jf);
            mapper.registerModule(new JodaModule());
            mapper.setDateFormat(new ISO8601DateFormat());
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            MetricsServlet metrics = new MetricsServlet(Clock.defaultClock(), vm, Metrics.defaultRegistry(), jf, true);
            JsonGenerator json = jf.createGenerator(outStream, JsonEncoding.UTF8);
            json.useDefaultPrettyPrinter();
            json.writeStartObject();
            IncidentUtil.writeVmMetrics(json, vm);
            metrics.writeRegularMetrics(json, null, false);
            json.writeEndObject();
            json.close();
            logger.debug("Creating full thread dump in dump file {}", dumpFile);
            writer.print("\n\n\n---------------------------  THREAD DUMP ---------------------------\n\n");
            writer.flush();
            vm.threadDump(outStream);
            logger.debug("Dump file {} is created.", dumpFile);
        }
    }

    private static void writeVmMetrics(JsonGenerator json, VirtualMachineMetrics vm) throws IOException {
        json.writeFieldName("jvm");
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", vm.name());
        json.writeStringField("version", vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        json.writeNumberField("totalInit", vm.totalInit());
        json.writeNumberField("totalUsed", vm.totalUsed());
        json.writeNumberField("totalMax", vm.totalMax());
        json.writeNumberField("totalCommitted", vm.totalCommitted());
        json.writeNumberField("heapInit", vm.heapInit());
        json.writeNumberField("heapUsed", vm.heapUsed());
        json.writeNumberField("heapMax", vm.heapMax());
        json.writeNumberField("heapCommitted", vm.heapCommitted());
        json.writeNumberField("heap_usage", vm.heapUsage());
        json.writeNumberField("non_heap_usage", vm.nonHeapUsage());
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        for (Map.Entry<String, Double> pool : vm.memoryPoolUsage().entrySet()) {
            json.writeNumberField(pool.getKey(), pool.getValue());
        }
        json.writeEndObject();
        json.writeEndObject();
        Map<String, VirtualMachineMetrics.BufferPoolStats> bufferPoolStats = vm.getBufferPoolStats();
        if (!bufferPoolStats.isEmpty()) {
            json.writeFieldName("buffers");
            json.writeStartObject();
            json.writeFieldName("direct");
            json.writeStartObject();
            json.writeNumberField("count", bufferPoolStats.get("direct").getCount());
            json.writeNumberField("memoryUsed", bufferPoolStats.get("direct").getMemoryUsed());
            json.writeNumberField("totalCapacity", bufferPoolStats.get("direct").getTotalCapacity());
            json.writeEndObject();
            json.writeFieldName("mapped");
            json.writeStartObject();
            json.writeNumberField("count", bufferPoolStats.get("mapped").getCount());
            json.writeNumberField("memoryUsed", bufferPoolStats.get("mapped").getMemoryUsed());
            json.writeNumberField("totalCapacity", bufferPoolStats.get("mapped").getTotalCapacity());
            json.writeEndObject();
            json.writeEndObject();
        }
        json.writeNumberField("daemon_thread_count", vm.daemonThreadCount());
        json.writeNumberField("thread_count", vm.threadCount());
        json.writeNumberField("current_time", Clock.defaultClock().time());
        json.writeNumberField("uptime", vm.uptime());
        json.writeNumberField("fd_usage", vm.fileDescriptorUsage());
        json.writeFieldName("thread-states");
        json.writeStartObject();
        for (Map.Entry<Thread.State, Double> entry : vm.threadStatePercentages().entrySet()) {
            json.writeNumberField(entry.getKey().toString().toLowerCase(), entry.getValue());
        }
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry<Object, Object> entry : vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            VirtualMachineMetrics.GarbageCollectorStats gc = (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue();
            json.writeNumberField("runs", gc.getRuns());
            json.writeNumberField("time", gc.getTime(TimeUnit.MILLISECONDS));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
    }
}

